/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.checkedhello;

import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.exception.NativeLibException;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.core.os.RegistryDefaultHandler;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.panels.checkedhello.RegistryHelper;
import com.izforge.izpack.panels.hello.HelloPanel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CheckedHelloPanel
extends HelloPanel {
    private static final long serialVersionUID = 1737042770727953387L;
    protected boolean abortInstallation;
    private final transient RegistryHelper registryHelper;
    private static Logger logger = Logger.getLogger(CheckedHelloPanel.class.getName());

    public CheckedHelloPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, RegistryDefaultHandler handler, Log log) throws Exception {
        super(panel, parent, installData, resources, log);
        this.registryHelper = new RegistryHelper(handler, installData);
        this.abortInstallation = this.isRegistered();
    }

    protected boolean multipleInstall() throws NativeLibException {
        String path = this.registryHelper.getInstallationPath();
        if (path == null) {
            path = "<not found>";
        }
        String noLuck = this.getString("CheckedHelloPanel.productAlreadyExist0") + path + " . " + this.getString("CheckedHelloPanel.productAlreadyExist1");
        return this.askQuestion(this.getString("installer.error"), noLuck, 37) == 47;
    }

    protected boolean isRegistered() throws Exception {
        return this.registryHelper.isRegistered();
    }

    @Override
    public boolean isValidated() {
        return !this.abortInstallation;
    }

    @Override
    public void panelActivate() {
        if (this.abortInstallation) {
            this.parent.lockNextButton();
            try {
                if (this.multipleInstall()) {
                    this.setUniqueUninstallKey();
                    this.abortInstallation = false;
                    this.parent.unlockNextButton();
                } else {
                    this.installData.getInfo().setUninstallerPath(null);
                    this.installData.getInfo().setUninstallerName(null);
                    this.installData.getInfo().setUninstallerCondition("uninstaller.nowrite");
                }
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        this.installData.setVariable("UNINSTALL_NAME", this.registryHelper.getUninstallName());
    }

    private void setUniqueUninstallKey() throws NativeLibException {
        String newUninstallName = this.registryHelper.updateUninstallName();
        this.emitNotification(this.getString("CheckedHelloPanel.infoOverUninstallKey") + newUninstallName);
    }
}

