/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.debugger;

import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.installer.debugger.ConditionHistory;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ConditionHistoryTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 5966543100431588652L;
    public static final String[] columnheader = new String[]{"Id", "Value"};
    private final List<ConditionHistory> tableValues = new ArrayList<ConditionHistory>();

    @Override
    public int getColumnCount() {
        return columnheader.length;
    }

    @Override
    public int getRowCount() {
        return this.tableValues.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex > this.tableValues.size() || columnIndex < 0) {
            return null;
        }
        ConditionHistory conditionHistory = this.tableValues.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return conditionHistory.getId();
            }
            case 1: {
                return conditionHistory;
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        return columnheader[column];
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 1) {
            return ConditionHistory.class;
        }
        return String.class;
    }

    public void clearState() {
        for (ConditionHistory conditionHistory : this.tableValues) {
            conditionHistory.clearState();
        }
    }

    public void setValue(Condition condition, boolean currentValue, String comment) {
        ConditionHistory conditionHistory = this.tableValues.stream().filter(ch -> ch.getId().equals(condition.getId())).findFirst().orElse(null);
        if (conditionHistory == null) {
            conditionHistory = new ConditionHistory(condition);
            this.tableValues.add(conditionHistory);
        }
        conditionHistory.addValue(currentValue, comment);
    }
}

