"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useClampText = void 0;
var react_1 = require("react");
var rooks_1 = require("rooks");
var defaultEllipsis = '...';
var key = 0;
var getNewKey = function () { return "__clamp_text_key__".concat(key++); };
function useClampText(_a) {
    var text = _a.text, _b = _a.ellipsis, ellipsis = _b === void 0 ? defaultEllipsis : _b, _c = _a.lines, lines = _c === void 0 ? 3 : _c, _d = _a.expanded, expanded = _d === void 0 ? false : _d, _e = _a.debounceTime, debounceTime = _e === void 0 ? 300 : _e, _f = _a.charWidth, charWidth = _f === void 0 ? 1.2 : _f;
    var _g = (0, react_1.useState)(function () { return ({
        noClamp: false,
        clampedText: '.',
        key: getNewKey(),
    }); }), _h = _g[0], noClamp = _h.noClamp, clampedText = _h.clampedText, key = _h.key, setState = _g[1];
    var nodeRef = (0, react_1.useRef)();
    var lineHeightRef = (0, react_1.useRef)(0);
    var clampLines = (0, react_1.useCallback)(function (_a) {
        var lineHeight = _a.lineHeight, originalText = _a.originalText, expanded = _a.expanded, ellipsis = _a.ellipsis, lines = _a.lines, charWidth = _a.charWidth;
        var node = nodeRef.current;
        if (!node) {
            return;
        }
        if (!originalText || expanded) {
            setState({
                noClamp: true,
                clampedText: originalText,
                key: getNewKey(),
            });
            return;
        }
        var maxHeight = lineHeight * lines + 1;
        var ellipsisLength = 0;
        if (typeof ellipsis === 'string') {
            ellipsisLength =
                ellipsis === defaultEllipsis
                    ? 5
                    : Math.ceil(ellipsis.length * charWidth);
        }
        else if (typeof ellipsis === 'number') {
            ellipsisLength = Math.ceil(ellipsis * charWidth);
        }
        var start = 0;
        var middle = 0;
        var end = originalText.length;
        if (!node.clientHeight) {
            return;
        }
        function moveMarkers() {
            var _a;
            var clientHeight = (_a = node === null || node === void 0 ? void 0 : node.clientHeight) !== null && _a !== void 0 ? _a : 1;
            if (clientHeight <= maxHeight) {
                start = middle + 1;
            }
            else {
                end = middle - 1;
            }
        }
        while (start <= end) {
            middle = Math.floor((start + end) / 2);
            node.innerText = originalText.slice(0, middle);
            if (middle === originalText.length) {
                setState({
                    clampedText: originalText,
                    noClamp: true,
                    key: getNewKey(),
                });
                return;
            }
            moveMarkers();
        }
        var clampedText = originalText.slice(0, Math.max(middle - ellipsisLength, 0)).trim() +
            (typeof ellipsis === 'string' ? ellipsis : '');
        node.innerText = clampedText;
        setState({
            noClamp: false,
            clampedText: clampedText,
            key: getNewKey(),
        });
    }, []);
    var debouncedClampLines = (0, rooks_1.useDebounce)(clampLines, debounceTime);
    (0, rooks_1.useOnWindowResize)(function () {
        return debouncedClampLines({
            lineHeight: lineHeightRef.current,
            originalText: text,
            expanded: expanded,
            ellipsis: ellipsis,
            lines: lines,
            charWidth: charWidth,
        });
    });
    (0, rooks_1.useDidMount)(function () {
        var _a, _b;
        if (text && !lineHeightRef.current) {
            var lineHeight = ((_b = (_a = nodeRef.current) === null || _a === void 0 ? void 0 : _a.clientHeight) !== null && _b !== void 0 ? _b : 1) + 1;
            lineHeightRef.current = lineHeight;
            clampLines({
                lineHeight: lineHeight,
                originalText: text,
                expanded: expanded,
                ellipsis: ellipsis,
                lines: lines,
                charWidth: charWidth,
            });
        }
    });
    (0, rooks_1.useDidUpdate)(function () {
        clampLines({
            lineHeight: lineHeightRef.current,
            originalText: text,
            expanded: expanded,
            ellipsis: ellipsis,
            lines: lines,
            charWidth: charWidth,
        });
    }, [expanded, text, charWidth, ellipsis, lines]);
    return [
        nodeRef,
        {
            noClamp: noClamp,
            clampedText: clampedText,
            key: key,
        },
    ];
}
exports.useClampText = useClampText;
