(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('react')) :
  typeof define === 'function' && define.amd ? define(['exports', 'react'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.rooks = {}, global.React));
}(this, (function (exports, react) { 'use strict';

  /**
   * useDidMount hook
   * Calls a function on mount
   *
   * @param {Function} callback Callback function to be called on mount
   *
   */
  function useDidMount(callback) {
      react.useEffect(function () {
          if (typeof callback === "function") {
              callback();
          }
      }, []);
  }

  var noop = function () { };

  var config = {
      attributes: true,
      characterData: true,
      childList: true,
      subtree: true,
  };
  /**
   *
   * useMutationObserver hook
   *
   * Returns a mutation observer for a React Ref and fires a callback
   *
   * @param {MutableRefObject<HTMLElement | null>} ref React ref on which mutations are to be observed
   * @param {MutationCallback} callback Function that needs to be fired on mutation
   * @param {MutationObserverInit} options
   */
  function useMutationObserver(ref, callback, options) {
      if (options === void 0) { options = config; }
      react.useEffect(function () {
          // Create an observer instance linked to the callback function
          if (ref.current) {
              var observer_1 = new MutationObserver(callback);
              // Start observing the target node for configured mutations
              observer_1.observe(ref.current, options);
              return function () {
                  observer_1.disconnect();
              };
          }
          return noop;
      }, [callback, options]);
  }

  /**
   * @param element HTML element whose boundingclientrect is needed
   * @returns ClientRect
   */
  function getBoundingClientRect(element) {
      return element.getBoundingClientRect();
  }
  /**
   * useBoundingclientRect hook
   *
   * @param ref The React ref whose ClientRect is needed
   * @returns ClientRect
   */
  function useBoundingclientrect(ref) {
      var _a = react.useState(null), value = _a[0], setValue = _a[1];
      var update = react.useCallback(function () {
          setValue(ref.current ? getBoundingClientRect(ref.current) : null);
      }, []);
      useDidMount(function () {
          update();
      });
      useMutationObserver(ref, update);
      return value;
  }

  /**
   * Credit to material-ui for this snippet
   */
  function setRef(ref, value) {
      if (typeof ref === 'function') {
          ref(value);
      }
      else if (ref) {
          ref.current = value;
      }
  }
  /**
   * useForkRef
   * Joins refs together and returns a combination of the two as a new ref
   *
   * @param refA
   * @param refB
   */
  function useForkRef(refA, refB) {
      /**
       * This will create a new function if the ref props change and are defined.
       * This means react will call the old forkRef with `null` and the new forkRef
       * with the ref. Cleanup naturally emerges from this behavior
       */
      return react.useMemo(function () {
          if (refA == null && refB == null) {
              return null;
          }
          return function (refValue) {
              setRef(refA, refValue);
              setRef(refB, refValue);
          };
      }, [refA, refB]);
  }

  var config$1 = {
      attributes: true,
      characterData: true,
      childList: true,
      subtree: true,
  };
  /**
   *
   * useMutationObserverRef hook
   *
   * Returns a mutation observer for a React Ref and fires a callback
   *
   * @param {MutationCallback} callback Function that needs to be fired on mutation
   * @param {MutationObserverInit} options
   */
  function useMutationObserverRef(callback, options) {
      if (options === void 0) { options = config$1; }
      var _a = react.useState(null), node = _a[0], setNode = _a[1];
      react.useEffect(function () {
          // Create an observer instance linked to the callback function
          if (node) {
              var observer_1 = new MutationObserver(callback);
              // Start observing the target node for configured mutations
              observer_1.observe(node, options);
              return function () {
                  observer_1.disconnect();
              };
          }
          return noop;
      }, [node, callback, options]);
      var ref = react.useCallback(function (node) {
          setNode(node);
      }, []);
      return [ref];
  }

  /**
   * @param element HTML element whose boundingclientrect is needed
   * @returns ClientRect
   */
  function getBoundingClientRect$1(element) {
      return element.getBoundingClientRect();
  }
  /**
   * useBoundingclientrectRef hook
   *
   * @returns [CallbackRef | null, ClientRect | DOMRect | null, () => void]
   */
  function useBoundingclientrectRef() {
      var _a = react.useState(null), value = _a[0], setValue = _a[1];
      var _b = react.useState(null), node = _b[0], setNode = _b[1];
      var update = react.useCallback(function () {
          setValue(node ? getBoundingClientRect$1(node) : null);
      }, [node]);
      react.useEffect(function () {
          update();
      }, [node]);
      var ref = react.useCallback(function (node) {
          setNode(node);
      }, []);
      var mutationObserverRef = useMutationObserverRef(update)[0];
      var forkedRef = useForkRef(ref, mutationObserverRef);
      return [forkedRef, value, update];
  }

  /**
   * A setInterval hook that calls a callback after a interval duration
   * when a condition is true
   *
   * @param cb The callback to be invoked after interval
   * @param intervalDurationMs Amount of time in ms after which to invoke
   * @param when The condition which when true, sets the interval
   * @param startImmediate If the callback should be invoked immediately
   */
  function useIntervalWhen(callback_, intervalDurationMs, when, startImmediate) {
      if (intervalDurationMs === void 0) { intervalDurationMs = 0; }
      if (when === void 0) { when = true; }
      if (startImmediate === void 0) { startImmediate = false; }
      var savedRefCallback = react.useRef();
      react.useEffect(function () {
          savedRefCallback.current = callback_;
      });
      function callback() {
          savedRefCallback.current && savedRefCallback.current();
      }
      react.useEffect(function () {
          if (typeof window !== "undefined") {
              if (when) {
                  if (startImmediate) {
                      callback();
                  }
                  var interval_1 = window.setInterval(callback, intervalDurationMs);
                  return function () {
                      window.clearInterval(interval_1);
                  };
              }
          }
          else {
              console.warn("useIntervalWhen: window is undefined.");
          }
          return noop;
      }, [when, intervalDurationMs]);
  }

  /**
   *
   * useCountdown
   * Easy way to countdown until a given endtime in intervals
   *
   * @param endTime Time to countdown
   * @param options  Countdown options
   */
  function useCountdown(endTime, options) {
      if (options === void 0) { options = {}; }
      var _a = options.interval, interval = _a === void 0 ? 1000 : _a, onDown = options.onDown, onEnd = options.onEnd;
      var _b = react.useState(function () { return new Date(); }), time = _b[0], setTime = _b[1];
      var restTime = endTime.getTime() - time.getTime();
      var count = restTime > 0 ? Math.ceil(restTime / interval) : 0;
      useIntervalWhen(onTick, count ? interval : undefined, true, true);
      return count;
      function onTick() {
          var newTime = new Date();
          if (newTime > endTime) {
              if (onEnd) {
                  onEnd(newTime);
              }
              setTime(endTime);
              return;
          }
          if (onDown) {
              onDown(restTime, newTime);
          }
          setTime(newTime);
      }
  }

  /**
   *
   * @typedef handler
   * @type {Object}
   * @property {number} value The value of the counter
   * @property {Function}  increment Increment counter value by 1
   * @property {Function} decrement Decrement counter value by 1
   * @property {Function} incrementBy Increment counter by incrAmount
   * @property {Function} decrementBy Decrement counter by decrAmount
   * @property {Function} reset Reset counter to initialValue
   */
  /**
   * Counter hook
   *
   * @param {number} initialValue The initial value of the counter
   * @returns {handler} A handler to interact with the counter
   */
  function useCounter(initialValue) {
      var _a = react.useState(initialValue), counter = _a[0], setCounter = _a[1];
      /**
       * Increment counter by an amount
       *
       * @param {number} incrAmount
       */
      var incrementBy = react.useCallback(function (incrAmount) {
          setCounter(function (currentCounter) { return currentCounter + incrAmount; });
      }, []);
      /**
       *
       * Decrement counter by an amount
       *
       * @param {*} decrAmount
       */
      var decrementBy = react.useCallback(function (decrAmount) {
          incrementBy(-decrAmount);
      }, []);
      /**
       * Increment counter by 1
       */
      var increment = react.useCallback(function () {
          incrementBy(1);
      }, []);
      /**
       * Decrement counter by 1
       */
      var decrement = react.useCallback(function () {
          incrementBy(-1);
      }, []);
      /**
       * Reset counter to initial value
       */
      var reset = react.useCallback(function () {
          setCounter(initialValue);
      }, []);
      return {
          decrement: decrement,
          decrementBy: decrementBy,
          increment: increment,
          incrementBy: incrementBy,
          reset: reset,
          value: counter,
      };
  }

  /**
   * lodash (Custom Build) <https://lodash.com/>
   * Build: `lodash modularize exports="npm" -o ./`
   * Copyright jQuery Foundation and other contributors <https://jquery.org/>
   * Released under MIT license <https://lodash.com/license>
   * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
   * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
   */
  /** Used as the `TypeError` message for "Functions" methods. */
  var FUNC_ERROR_TEXT = 'Expected a function';

  /** Used as references for various `Number` constants. */
  var NAN = 0 / 0;

  /** `Object#toString` result references. */
  var symbolTag = '[object Symbol]';

  /** Used to match leading and trailing whitespace. */
  var reTrim = /^\s+|\s+$/g;

  /** Used to detect bad signed hexadecimal string values. */
  var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;

  /** Used to detect binary string values. */
  var reIsBinary = /^0b[01]+$/i;

  /** Used to detect octal string values. */
  var reIsOctal = /^0o[0-7]+$/i;

  /** Built-in method references without a dependency on `root`. */
  var freeParseInt = parseInt;

  /** Detect free variable `global` from Node.js. */
  var freeGlobal = typeof global == 'object' && global && global.Object === Object && global;

  /** Detect free variable `self`. */
  var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

  /** Used as a reference to the global object. */
  var root = freeGlobal || freeSelf || Function('return this')();

  /** Used for built-in method references. */
  var objectProto = Object.prototype;

  /**
   * Used to resolve the
   * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
   * of values.
   */
  var objectToString = objectProto.toString;

  /* Built-in method references for those with the same name as other `lodash` methods. */
  var nativeMax = Math.max,
      nativeMin = Math.min;

  /**
   * Gets the timestamp of the number of milliseconds that have elapsed since
   * the Unix epoch (1 January 1970 00:00:00 UTC).
   *
   * @static
   * @memberOf _
   * @since 2.4.0
   * @category Date
   * @returns {number} Returns the timestamp.
   * @example
   *
   * _.defer(function(stamp) {
   *   console.log(_.now() - stamp);
   * }, _.now());
   * // => Logs the number of milliseconds it took for the deferred invocation.
   */
  var now = function() {
    return root.Date.now();
  };

  /**
   * Creates a debounced function that delays invoking `func` until after `wait`
   * milliseconds have elapsed since the last time the debounced function was
   * invoked. The debounced function comes with a `cancel` method to cancel
   * delayed `func` invocations and a `flush` method to immediately invoke them.
   * Provide `options` to indicate whether `func` should be invoked on the
   * leading and/or trailing edge of the `wait` timeout. The `func` is invoked
   * with the last arguments provided to the debounced function. Subsequent
   * calls to the debounced function return the result of the last `func`
   * invocation.
   *
   * **Note:** If `leading` and `trailing` options are `true`, `func` is
   * invoked on the trailing edge of the timeout only if the debounced function
   * is invoked more than once during the `wait` timeout.
   *
   * If `wait` is `0` and `leading` is `false`, `func` invocation is deferred
   * until to the next tick, similar to `setTimeout` with a timeout of `0`.
   *
   * See [David Corbacho's article](https://css-tricks.com/debouncing-throttling-explained-examples/)
   * for details over the differences between `_.debounce` and `_.throttle`.
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Function
   * @param {Function} func The function to debounce.
   * @param {number} [wait=0] The number of milliseconds to delay.
   * @param {Object} [options={}] The options object.
   * @param {boolean} [options.leading=false]
   *  Specify invoking on the leading edge of the timeout.
   * @param {number} [options.maxWait]
   *  The maximum time `func` is allowed to be delayed before it's invoked.
   * @param {boolean} [options.trailing=true]
   *  Specify invoking on the trailing edge of the timeout.
   * @returns {Function} Returns the new debounced function.
   * @example
   *
   * // Avoid costly calculations while the window size is in flux.
   * jQuery(window).on('resize', _.debounce(calculateLayout, 150));
   *
   * // Invoke `sendMail` when clicked, debouncing subsequent calls.
   * jQuery(element).on('click', _.debounce(sendMail, 300, {
   *   'leading': true,
   *   'trailing': false
   * }));
   *
   * // Ensure `batchLog` is invoked once after 1 second of debounced calls.
   * var debounced = _.debounce(batchLog, 250, { 'maxWait': 1000 });
   * var source = new EventSource('/stream');
   * jQuery(source).on('message', debounced);
   *
   * // Cancel the trailing debounced invocation.
   * jQuery(window).on('popstate', debounced.cancel);
   */
  function debounce(func, wait, options) {
    var lastArgs,
        lastThis,
        maxWait,
        result,
        timerId,
        lastCallTime,
        lastInvokeTime = 0,
        leading = false,
        maxing = false,
        trailing = true;

    if (typeof func != 'function') {
      throw new TypeError(FUNC_ERROR_TEXT);
    }
    wait = toNumber(wait) || 0;
    if (isObject(options)) {
      leading = !!options.leading;
      maxing = 'maxWait' in options;
      maxWait = maxing ? nativeMax(toNumber(options.maxWait) || 0, wait) : maxWait;
      trailing = 'trailing' in options ? !!options.trailing : trailing;
    }

    function invokeFunc(time) {
      var args = lastArgs,
          thisArg = lastThis;

      lastArgs = lastThis = undefined;
      lastInvokeTime = time;
      result = func.apply(thisArg, args);
      return result;
    }

    function leadingEdge(time) {
      // Reset any `maxWait` timer.
      lastInvokeTime = time;
      // Start the timer for the trailing edge.
      timerId = setTimeout(timerExpired, wait);
      // Invoke the leading edge.
      return leading ? invokeFunc(time) : result;
    }

    function remainingWait(time) {
      var timeSinceLastCall = time - lastCallTime,
          timeSinceLastInvoke = time - lastInvokeTime,
          result = wait - timeSinceLastCall;

      return maxing ? nativeMin(result, maxWait - timeSinceLastInvoke) : result;
    }

    function shouldInvoke(time) {
      var timeSinceLastCall = time - lastCallTime,
          timeSinceLastInvoke = time - lastInvokeTime;

      // Either this is the first call, activity has stopped and we're at the
      // trailing edge, the system time has gone backwards and we're treating
      // it as the trailing edge, or we've hit the `maxWait` limit.
      return (lastCallTime === undefined || (timeSinceLastCall >= wait) ||
        (timeSinceLastCall < 0) || (maxing && timeSinceLastInvoke >= maxWait));
    }

    function timerExpired() {
      var time = now();
      if (shouldInvoke(time)) {
        return trailingEdge(time);
      }
      // Restart the timer.
      timerId = setTimeout(timerExpired, remainingWait(time));
    }

    function trailingEdge(time) {
      timerId = undefined;

      // Only invoke if we have `lastArgs` which means `func` has been
      // debounced at least once.
      if (trailing && lastArgs) {
        return invokeFunc(time);
      }
      lastArgs = lastThis = undefined;
      return result;
    }

    function cancel() {
      if (timerId !== undefined) {
        clearTimeout(timerId);
      }
      lastInvokeTime = 0;
      lastArgs = lastCallTime = lastThis = timerId = undefined;
    }

    function flush() {
      return timerId === undefined ? result : trailingEdge(now());
    }

    function debounced() {
      var time = now(),
          isInvoking = shouldInvoke(time);

      lastArgs = arguments;
      lastThis = this;
      lastCallTime = time;

      if (isInvoking) {
        if (timerId === undefined) {
          return leadingEdge(lastCallTime);
        }
        if (maxing) {
          // Handle invocations in a tight loop.
          timerId = setTimeout(timerExpired, wait);
          return invokeFunc(lastCallTime);
        }
      }
      if (timerId === undefined) {
        timerId = setTimeout(timerExpired, wait);
      }
      return result;
    }
    debounced.cancel = cancel;
    debounced.flush = flush;
    return debounced;
  }

  /**
   * Checks if `value` is the
   * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
   * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is an object, else `false`.
   * @example
   *
   * _.isObject({});
   * // => true
   *
   * _.isObject([1, 2, 3]);
   * // => true
   *
   * _.isObject(_.noop);
   * // => true
   *
   * _.isObject(null);
   * // => false
   */
  function isObject(value) {
    var type = typeof value;
    return !!value && (type == 'object' || type == 'function');
  }

  /**
   * Checks if `value` is object-like. A value is object-like if it's not `null`
   * and has a `typeof` result of "object".
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
   * @example
   *
   * _.isObjectLike({});
   * // => true
   *
   * _.isObjectLike([1, 2, 3]);
   * // => true
   *
   * _.isObjectLike(_.noop);
   * // => false
   *
   * _.isObjectLike(null);
   * // => false
   */
  function isObjectLike(value) {
    return !!value && typeof value == 'object';
  }

  /**
   * Checks if `value` is classified as a `Symbol` primitive or object.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
   * @example
   *
   * _.isSymbol(Symbol.iterator);
   * // => true
   *
   * _.isSymbol('abc');
   * // => false
   */
  function isSymbol(value) {
    return typeof value == 'symbol' ||
      (isObjectLike(value) && objectToString.call(value) == symbolTag);
  }

  /**
   * Converts `value` to a number.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to process.
   * @returns {number} Returns the number.
   * @example
   *
   * _.toNumber(3.2);
   * // => 3.2
   *
   * _.toNumber(Number.MIN_VALUE);
   * // => 5e-324
   *
   * _.toNumber(Infinity);
   * // => Infinity
   *
   * _.toNumber('3.2');
   * // => 3.2
   */
  function toNumber(value) {
    if (typeof value == 'number') {
      return value;
    }
    if (isSymbol(value)) {
      return NAN;
    }
    if (isObject(value)) {
      var other = typeof value.valueOf == 'function' ? value.valueOf() : value;
      value = isObject(other) ? (other + '') : other;
    }
    if (typeof value != 'string') {
      return value === 0 ? value : +value;
    }
    value = value.replace(reTrim, '');
    var isBinary = reIsBinary.test(value);
    return (isBinary || reIsOctal.test(value))
      ? freeParseInt(value.slice(2), isBinary ? 2 : 8)
      : (reIsBadHex.test(value) ? NAN : +value);
  }

  var lodash_debounce = debounce;

  /**
   * Debounce hook
   * Debounces a function
   *
   * @param callback The callback to debounce
   * @param wait The duration to debounce
   * @param options The options object.
   * @param options.leading Specify invoking on the leading edge of the timeout.
   * @param options.maxWait The maximum time func is allowed to be delayed before it’s invoked.
   * @param options.trailing Specify invoking on the trailing edge of the timeout.
   * @returns Returns the new debounced function.
   */
  function useDebounce(callback, wait, options) {
      var createDebouncedCallback = react.useCallback(function (function_) {
          return lodash_debounce(function_, wait, options);
      }, [wait, options]);
      var debouncedCallbackRef = react.useRef(createDebouncedCallback(callback));
      react.useEffect(function () {
          debouncedCallbackRef.current = createDebouncedCallback(callback);
      }, [callback, createDebouncedCallback]);
      return debouncedCallbackRef.current;
  }

  /**
   *  useDidUpdate hook
   *
   *  Fires a callback on component update
   *  Can take in a list of conditions to fire callback when one of the
   *  conditions changes
   *
   * @param {Function} callback The callback to be called on update
   * @param {Array} conditions The list of variables which trigger update when they are changed
   */
  function useDidUpdate(callback, conditions) {
      var hasMountedRef = react.useRef(false);
      if (typeof conditions !== "undefined" && !Array.isArray(conditions)) {
          conditions = [conditions];
      }
      else if (Array.isArray(conditions) && conditions.length === 0) {
          console.warn("Using [] as the second argument makes useDidUpdate a noop. The second argument should either be `undefined` or an array of length greater than 0.");
      }
      react.useEffect(function () {
          if (hasMountedRef.current) {
              callback();
          }
          else {
              hasMountedRef.current = true;
          }
      }, conditions);
      react.useEffect(function () {
          return function () {
              hasMountedRef.current = false;
          };
      }, []);
  }

  var defaultUseDebounceValueOptions = {
      initializeWithNull: false,
  };
  var useDebouncedValue = function (value, timeout, options) {
      if (options === void 0) { options = {}; }
      // eslint-disable-next-line prefer-object-spread
      var initializeWithNull = Object.assign({}, defaultUseDebounceValueOptions, options).initializeWithNull;
      var _a = react.useState(initializeWithNull ? null : value), updatedValue = _a[0], setUpdatedValue = _a[1];
      var debouncedSetUpdatedValue = useDebounce(setUpdatedValue, timeout);
      useDidMount(function () {
          if (initializeWithNull) {
              debouncedSetUpdatedValue(value);
          }
      });
      useDidUpdate(function () {
          debouncedSetUpdatedValue(value);
      }, [value]);
      // No need to add `debouncedSetUpdatedValue ` to dependencies as it is a ref.current.
      // returning both updatedValue and setUpdatedValue (not the debounced version) to instantly update this if  needed.
      return [updatedValue, setUpdatedValue];
  };

  /**
   * useIsomorphicEffect
   * Resolves to useEffect when "window" is not in scope and useLayout effect in the browser
   *
   * @param {Function} callback Callback function to be called on mount
   */
  var useIsomorphicEffect = typeof window === 'undefined' ? react.useEffect : react.useLayoutEffect;

  /**
   * useFreshRef
   *
   * @param value The value which needs to be fresh at all times. Probably
   * best used with functions
   * @param preferLayoutEffect Should the value be updated using a layout effect
   * or a passive effect. Defaults to false.
   * @returns A ref containing the fresh value
   */
  function useFreshRef(value, preferLayoutEffect) {
      if (preferLayoutEffect === void 0) { preferLayoutEffect = false; }
      var useEffectToUse = preferLayoutEffect ? useIsomorphicEffect : react.useEffect;
      var ref = react.useRef(value);
      useEffectToUse(function () {
          ref.current = value;
      });
      return ref;
  }

  function useFreshTick(callback) {
      var freshRef = useFreshRef(callback);
      function tick() {
          var args = [];
          for (var _i = 0; _i < arguments.length; _i++) {
              args[_i] = arguments[_i];
          }
          if (typeof freshRef.current === "function") {
              freshRef.current.apply(freshRef, args);
          }
      }
      return tick;
  }

  var isDevelopmentEnvironment = process.env.NODE_ENV !== "production";
  // eslint-disable-next-line import/no-mutable-exports
  var warning = function () { };
  if (isDevelopmentEnvironment) {
      var printWarning_1 = function (actualMessage) {
          var message = "Warning: ".concat(actualMessage);
          if (typeof console !== "undefined") {
              console.error(message);
          }
          try {
              // --- Welcome to debugging React ---
              // This error was thrown as a convenience so that you can use this stack
              // to find the call site that caused this warning to fire.
              throw new Error(message);
              // eslint-disable-next-line no-empty
          }
          catch (_a) { }
      };
      warning = function (condition, actualMessage) {
          if (!condition) {
              printWarning_1(actualMessage);
          }
      };
  }

  /**
   *  useGlobalObjectEventListener hook
   *
   *  A react hook to an event listener to a global object
   *
   * @param {Window|Document} globalObject The global object to add event onto
   * @param {string} eventName The event to track
   * @param {Function} callback The callback to be called on event
   * @param {ListenerOptions} listenerOptions The options to be passed to the event listener
   * @param {boolean} when Should the event listener be active
   * @param {boolean} isLayoutEffect Should it use layout effect. Defaults to false
   * @returns {undefined}
   */
  function useGlobalObjectEventListener(globalObject, eventName, callback, listenerOptions, when, isLayoutEffect) {
      if (listenerOptions === void 0) { listenerOptions = {}; }
      if (when === void 0) { when = true; }
      if (isLayoutEffect === void 0) { isLayoutEffect = false; }
      var freshCallback = useFreshTick(callback);
      var useEffectToRun = isLayoutEffect ? useIsomorphicEffect : react.useEffect;
      useEffectToRun(function () {
          warning(typeof globalObject !== "undefined", "[useGlobalObjectEventListener]: Cannot attach event handlers to undefined.");
          if (typeof globalObject !== "undefined" && when) {
              globalObject.addEventListener(eventName, freshCallback, listenerOptions);
              return function () {
                  globalObject.removeEventListener(eventName, freshCallback, listenerOptions);
              };
          }
          return function () { };
      }, [eventName, listenerOptions]);
  }

  /**
   *
   * useOnWindowResize hook
   *
   * Fires a callback when window resizes
   *
   * @param {Function} callback Callback to be called before unmount
   * @param {boolean} when When the handler should be applied
   * @param {boolean} isLayoutEffect Should it use layout effect. Defaults to false
   */
  function useOnWindowResize(callback, when, isLayoutEffect) {
      if (when === void 0) { when = true; }
      if (isLayoutEffect === void 0) { isLayoutEffect = false; }
      if (typeof window !== "undefined") {
          useGlobalObjectEventListener(window, "resize", callback, { passive: true }, when, isLayoutEffect);
      }
      else {
          console.warn("useOnWindowResize can't attach an event listener as window is undefined.");
      }
  }

  /**
   *
   * useOnWindowScroll hook
   * Fires a callback when window scroll
   *
   * @param {Function} callback Callback to be called before unmount
   * @param {boolean} when When the handler should be applied
   * @param {boolean} isLayoutEffect Should it use layout effect. Defaults to false
   */
  function useOnWindowScroll(callback, when, isLayoutEffect) {
      if (when === void 0) { when = true; }
      if (isLayoutEffect === void 0) { isLayoutEffect = false; }
      if (typeof window !== "undefined") {
          useGlobalObjectEventListener(window, "scroll", callback, { passive: true }, when, isLayoutEffect);
      }
      else {
          console.warn("useOnWindowScroll can't attach an event listener as window is undefined.");
      }
  }

  /* eslint-disable id-length */
  var getDimensionObject = function (node) {
      var rect = node.getBoundingClientRect();
      return {
          bottom: rect.bottom,
          height: rect.height,
          left: rect.left,
          right: rect.right,
          top: rect.top,
          width: rect.width,
          x: rect.left,
          y: rect.top,
      };
  };
  var noWindowReturnValue = [undefined, null, null];
  var useDimensionsRef = function (_a) {
      var _b = _a === void 0 ? {} : _a, _c = _b.updateOnScroll, updateOnScroll = _c === void 0 ? true : _c, _d = _b.updateOnResize, updateOnResize = _d === void 0 ? true : _d;
      var _e = react.useState(null), dimensions = _e[0], setDimensions = _e[1];
      var _f = react.useState(null), node = _f[0], setNode = _f[1];
      var ref = react.useCallback(function (nodeFromCallback) {
          setNode(nodeFromCallback);
      }, []);
      var measure = react.useCallback(function () {
          window.requestAnimationFrame(function () {
              if (node) {
                  setDimensions(getDimensionObject(node));
              }
          });
      }, [node]);
      react.useLayoutEffect(function () {
          measure();
      }, [measure]);
      useOnWindowResize(function () {
          measure();
      }, updateOnResize, true);
      useOnWindowScroll(function () {
          measure();
      }, updateOnScroll, true);
      if (typeof window === "undefined") {
          console.warn("useDimensionsRef: window is undefined.");
          return noWindowReturnValue;
      }
      return [ref, dimensions, node];
  };

  /**
   *  useDocumentEventListener hook
   *
   *  A react hook to an event listener to the document
   *
   * @param {string} eventName The event to track
   * @param {Function} callback The callback to be called on event
   * @param {ListenerOptions} listenerOptions The options to be passed to the event listener
   * @param {boolean} isLayoutEffect Should it use layout effect. Defaults to false
   * @returns {undefined}
   */
  function useDocumentEventListener(eventName, callback, listenerOptions, isLayoutEffect) {
      if (listenerOptions === void 0) { listenerOptions = {}; }
      if (isLayoutEffect === void 0) { isLayoutEffect = false; }
      useGlobalObjectEventListener(document, eventName, callback, listenerOptions, true, isLayoutEffect);
  }

  /**
   * useEffectOnceWhen hook
   *
   * It fires a callback once when a condition is true or become true.
   * Fires the callback at most one time.
   *
   * @param callback The callback to fire
   * @param when The condition which needs to be true
   */
  function useEffectOnceWhen(callback, when) {
      if (when === void 0) { when = true; }
      var hasRunOnceRef = react.useRef(false);
      var callbackRef = react.useRef(callback);
      react.useEffect(function () {
          callbackRef.current = callback;
      });
      react.useEffect(function () {
          if (when && !hasRunOnceRef.current) {
              callbackRef.current();
              hasRunOnceRef.current = true;
          }
      }, [when]);
  }

  /**
   * useRefElement hook for React
   * Helps bridge gap between callback ref and state
   * Manages the element called with callback ref api using state variable
   */
  function useRefElement() {
      var _a = react.useState(null), refElement = _a[0], setRefElement = _a[1];
      var ref = react.useCallback(function (refElement) {
          setRefElement(refElement);
      }, []);
      return [ref, refElement];
  }

  /**
   *  useEventListenerRef hook
   *
   *  A react hook to an event listener to an element
   *  Returns a ref
   *
   * @param {string} eventName The event to track
   * @param {Function} callback The callback to be called on event
   * @param {object} conditions The options to be passed to the event listener
   * @param {boolean} isLayoutEffect Should it use layout effect. Defaults to false
   * @returns {Function} A callback ref that can be used as ref prop
   */
  function useEventListenerRef(eventName, callback, listenerOptions, isLayoutEffect) {
      if (listenerOptions === void 0) { listenerOptions = {}; }
      if (isLayoutEffect === void 0) { isLayoutEffect = false; }
      var _a = useRefElement(), ref = _a[0], element = _a[1];
      var freshCallback = useFreshTick(callback);
      var capture = listenerOptions.capture, passive = listenerOptions.passive, once = listenerOptions.once;
      var useEffectToRun = isLayoutEffect ? useIsomorphicEffect : react.useEffect;
      useEffectToRun(function () {
          if (!(element && element.addEventListener)) {
              return;
          }
          element.addEventListener(eventName, freshCallback, listenerOptions);
          return function () {
              element.removeEventListener(eventName, freshCallback, listenerOptions);
          };
      }, [element, eventName, capture, passive, once]);
      return ref;
  }

  /******************************************************************************
  Copyright (c) Microsoft Corporation.

  Permission to use, copy, modify, and/or distribute this software for any
  purpose with or without fee is hereby granted.

  THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
  REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
  AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
  INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
  LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
  OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
  PERFORMANCE OF THIS SOFTWARE.
  ***************************************************************************** */

  var __assign = function() {
      __assign = Object.assign || function __assign(t) {
          for (var s, i = 1, n = arguments.length; i < n; i++) {
              s = arguments[i];
              for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
          }
          return t;
      };
      return __assign.apply(this, arguments);
  };

  function __awaiter(thisArg, _arguments, P, generator) {
      function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
      return new (P || (P = Promise))(function (resolve, reject) {
          function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
          function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
          function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
          step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
  }

  function __generator(thisArg, body) {
      var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
      return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
      function verb(n) { return function (v) { return step([n, v]); }; }
      function step(op) {
          if (f) throw new TypeError("Generator is already executing.");
          while (_) try {
              if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
              if (y = 0, t) op = [op[0] & 2, t.value];
              switch (op[0]) {
                  case 0: case 1: t = op; break;
                  case 4: _.label++; return { value: op[1], done: false };
                  case 5: _.label++; y = op[1]; op = [0]; continue;
                  case 7: op = _.ops.pop(); _.trys.pop(); continue;
                  default:
                      if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                      if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                      if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                      if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                      if (t[2]) _.ops.pop();
                      _.trys.pop(); continue;
              }
              op = body.call(thisArg, _);
          } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
          if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
      }
  }

  function __spreadArray(to, from, pack) {
      if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
          if (ar || !(i in from)) {
              if (!ar) ar = Array.prototype.slice.call(from, 0, i);
              ar[i] = from[i];
          }
      }
      return to.concat(ar || Array.prototype.slice.call(from));
  }

  var getFullscreenControls = function () {
      var functionMap = [
          [
              "requestFullscreen",
              "exitFullscreen",
              "fullscreenElement",
              "fullscreenEnabled",
              "fullscreenchange",
              "fullscreenerror",
          ],
          // New WebKit
          [
              "webkitRequestFullscreen",
              "webkitExitFullscreen",
              "webkitFullscreenElement",
              "webkitFullscreenEnabled",
              "webkitfullscreenchange",
              "webkitfullscreenerror",
          ],
          // Old WebKit
          [
              "webkitRequestFullScreen",
              "webkitCancelFullScreen",
              "webkitCurrentFullScreenElement",
              "webkitCancelFullScreen",
              "webkitfullscreenchange",
              "webkitfullscreenerror",
          ],
          [
              "mozRequestFullScreen",
              "mozCancelFullScreen",
              "mozFullScreenElement",
              "mozFullScreenEnabled",
              "mozfullscreenchange",
              "mozfullscreenerror",
          ],
          [
              "msRequestFullscreen",
              "msExitFullscreen",
              "msFullscreenElement",
              "msFullscreenEnabled",
              "MSFullscreenChange",
              "MSFullscreenError",
          ],
      ];
      var returnValue = {};
      for (var _i = 0, functionMap_1 = functionMap; _i < functionMap_1.length; _i++) {
          var functionSet = functionMap_1[_i];
          if (functionSet && functionSet[1] in document) {
              for (var _a = 0, _b = functionSet.entries(); _a < _b.length; _a++) {
                  var _c = _b[_a], index = _c[0], _function = _c[1];
                  returnValue[functionMap[0][index]] = functionSet[index];
              }
          }
      }
      return returnValue;
  };
  var noop$1 = function () { };
  var defaultValue = {
      // isFullscreen
      element: undefined,
      // request
      exit: noop$1,
      isEnabled: false,
      // exit
      isFullscreen: false,
      // toggle
      onChange: noop$1,
      // onchange
      onError: noop$1,
      // onerror
      request: noop$1,
      toggle: noop$1,
  };
  function warnDeprecatedOnChangeAndOnErrorUsage() {
      warning(false, "Using onChange and onError from the return value is deprecated and \n    will be removed in the next major version. \n    Please use it with arguments instead. \n    For eg: useFullscreen({onChange: function() {}, onError: function(){}})\n  ");
  }
  /**
   * useFullscreen
   * A hook that helps make the document fullscreen
   */
  function useFullscreen(options) {
      var _this = this;
      if (options === void 0) { options = {}; }
      if (typeof window === "undefined") {
          console.warn("useFullscreen: window is undefined.");
          return defaultValue;
      }
      var onChangeArgument = options.onChange, onErrorArgument = options.onError, _a = options.requestFullscreenOptions, requestFullscreenOptions = _a === void 0 ? {} : _a;
      var fullscreenControls = getFullscreenControls();
      var _b = react.useState(Boolean(document[fullscreenControls.fullscreenElement])), isFullscreen = _b[0], setIsFullscreen = _b[1];
      var _c = react.useState(document[fullscreenControls.fullscreenElement]), element = _c[0], setElement = _c[1];
      var request = react.useCallback(function (element) { return __awaiter(_this, void 0, void 0, function () {
          var finalElement, error_1;
          return __generator(this, function (_a) {
              switch (_a.label) {
                  case 0:
                      _a.trys.push([0, 2, , 3]);
                      finalElement = element || document.documentElement;
                      return [4 /*yield*/, finalElement[fullscreenControls.requestFullscreen](requestFullscreenOptions)];
                  case 1: return [2 /*return*/, _a.sent()];
                  case 2:
                      error_1 = _a.sent();
                      console.log(error_1);
                      return [3 /*break*/, 3];
                  case 3: return [2 /*return*/];
              }
          });
      }); }, []);
      var exit = react.useCallback(function () { return __awaiter(_this, void 0, void 0, function () {
          var error_2;
          return __generator(this, function (_a) {
              switch (_a.label) {
                  case 0:
                      if (!element) return [3 /*break*/, 4];
                      _a.label = 1;
                  case 1:
                      _a.trys.push([1, 3, , 4]);
                      return [4 /*yield*/, document[fullscreenControls.exitFullscreen]()];
                  case 2: return [2 /*return*/, _a.sent()];
                  case 3:
                      error_2 = _a.sent();
                      console.warn(error_2);
                      return [3 /*break*/, 4];
                  case 4: return [2 /*return*/];
              }
          });
      }); }, [element]);
      var toggle = react.useCallback(function (newElement) {
          return element ? exit() : newElement ? request(newElement) : null;
      }, [element]);
      var onChangeDeprecatedHandlerRef = react.useRef(noop$1);
      var onErrorDeprecatedHandlerRef = react.useRef(noop$1);
      // Hack to not break it for everyone
      // Honestly these two functions are tragedy and must be removed in v5
      var onChangeDeprecated = react.useCallback(function (callback) {
          warnDeprecatedOnChangeAndOnErrorUsage();
          return (onChangeDeprecatedHandlerRef.current = callback);
      }, []);
      var onErrorDeprecated = react.useCallback(function (callback) {
          warnDeprecatedOnChangeAndOnErrorUsage();
          return (onErrorDeprecatedHandlerRef.current = callback);
      }, []);
      useDocumentEventListener(fullscreenControls.fullscreenchange, function (event) {
          var currentFullscreenElement = document[fullscreenControls.fullscreenElement];
          var isOpen = Boolean(currentFullscreenElement);
          if (isOpen) {
              // fullscreen was enabled
              setIsFullscreen(true);
              setElement(currentFullscreenElement);
          }
          else {
              // fullscreen was disabled
              setIsFullscreen(false);
              setElement(null);
          }
          onChangeArgument === null || onChangeArgument === void 0 ? void 0 : onChangeArgument.call(document, event, isOpen);
          onChangeDeprecatedHandlerRef.current.call(document, event, isOpen);
      });
      useDocumentEventListener(fullscreenControls.fullscreenerror, function (event) {
          onErrorArgument === null || onErrorArgument === void 0 ? void 0 : onErrorArgument.call(document, event);
          onErrorDeprecatedHandlerRef.current.call(document, event);
      });
      return {
          element: element,
          exit: exit,
          isEnabled: Boolean(document[fullscreenControls.fullscreenEnabled]),
          isFullscreen: isFullscreen,
          onChange: onChangeDeprecated,
          onError: onErrorDeprecated,
          request: request,
          toggle: toggle,
      };
  }

  /**
   * @description useGetIsMounted hook checks if a component is mounted or not at the time.
   * Useful for async effects. Returns a callback that returns a boolean representing if the component
   * is mounted at the time.
   * @returns () => boolean
   * @see https://react-hooks.org/docs/useGetIsMounted
   */
  var useGetIsMounted = function () {
      var isMountedRef = react.useRef(false);
      var get = react.useCallback(function () { return isMountedRef.current; }, []);
      react.useEffect(function () {
          isMountedRef.current = true;
          return function () {
              isMountedRef.current = false;
          };
      }, []);
      return get;
  };

  function getGeoLocation(options) {
      return new Promise(function (resolve, reject) {
          if (navigator.geolocation) {
              navigator.geolocation.getCurrentPosition(function (position) {
                  var coords = position.coords;
                  var latitude = coords.latitude, longitude = coords.longitude;
                  resolve({
                      isError: false,
                      lat: latitude,
                      lng: longitude,
                      message: "",
                  });
              }, function (error) {
                  reject({ isError: true, message: error.message });
              }, options);
          }
          else {
              reject({
                  isError: true,
                  message: "Geolocation is not supported for this Browser/OS.",
              });
          }
      });
  }
  // interface IUseGeoLocationHook {
  //   when?: boolean;
  // }
  // const defaultHookOptions = {
  //   when: true
  // };
  var defaultGeoLocationOptions = {
      enableHighAccuracy: false,
      maximumAge: 0,
      timeout: Number.POSITIVE_INFINITY,
      when: true,
  };
  /**
   * useGeolocation
   * Gets the geolocation data as a hook
   *
   * @param geoLocationOptions Geolocation options
   */
  function useGeolocation(
  // hooksOptions: IUseGeoLocationHook = defaultHookOptions,
  geoLocationOptions) {
      if (geoLocationOptions === void 0) { geoLocationOptions = defaultGeoLocationOptions; }
      var _a = react.useState(null), geoObject = _a[0], setGeoObject = _a[1];
      var when = geoLocationOptions.when, enableHighAccuracy = geoLocationOptions.enableHighAccuracy, timeout = geoLocationOptions.timeout, maximumAge = geoLocationOptions.maximumAge;
      react.useEffect(function () {
          function getGeoCode() {
              return __awaiter(this, void 0, void 0, function () {
                  var value, error_1;
                  return __generator(this, function (_a) {
                      switch (_a.label) {
                          case 0:
                              _a.trys.push([0, 2, , 3]);
                              return [4 /*yield*/, getGeoLocation({
                                      enableHighAccuracy: enableHighAccuracy,
                                      maximumAge: maximumAge,
                                      timeout: timeout,
                                      when: when,
                                  })];
                          case 1:
                              value = _a.sent();
                              setGeoObject(value);
                              return [3 /*break*/, 3];
                          case 2:
                              error_1 = _a.sent();
                              setGeoObject(error_1);
                              return [3 /*break*/, 3];
                          case 3: return [2 /*return*/];
                      }
                  });
              });
          }
          if (when) {
              getGeoCode();
          }
      }, [when, enableHighAccuracy, timeout, maximumAge]);
      return geoObject;
  }

  var defaultOptions = {};
  /**
   *
   * useInput Hook
   *
   * Handles an input's value and onChange props internally to
   * make text input creation process easier
   *
   * @param {unknown} [initialValue] Initial value of the input
   * @param {Options} [options] Options object
   * @returns {InputHandler} Input handler with value and onChange
   */
  function useInput(initialValue, options) {
      if (initialValue === void 0) { initialValue = ""; }
      if (options === void 0) { options = defaultOptions; }
      var _a = react.useState(initialValue), value = _a[0], setValue = _a[1];
      var onChange = react.useCallback(function (event) {
          var newValue = event.target.value;
          var shouldUpdate = true;
          if (typeof options.validate === "function") {
              shouldUpdate = options.validate(newValue, value);
          }
          if (shouldUpdate) {
              setValue(newValue);
          }
      }, [options, value]);
      // sync with default value
      react.useEffect(function () {
          setValue(initialValue);
      }, [initialValue]);
      var handler = {
          onChange: onChange,
          value: value,
      };
      return handler;
  }

  function useWarningOnMountInDevelopment(message) {
      useDidMount(function () {
          warning(false, message);
      });
  }

  // See also: https://overreacted.io/making-setinterval-declarative-with-react-hooks/
  /**
   *
   * useInterval hook
   *
   * Declaratively creates a setInterval to run a callback after a fixed
   * amount of time
   *
   *@param {Function} callback - Callback to be fired
   *@param {number} intervalId - Interval duration in milliseconds after which the callback is to be fired
   *@param {boolean} startImmediate - Whether the interval should start immediately on initialise
   *@returns {IntervalHandler}
   */
  function useInterval(callback, intervalDuration, startImmediate) {
      if (startImmediate === void 0) { startImmediate = false; }
      useWarningOnMountInDevelopment("useInterval is deprecated, it will be removed in rooks v7. Please use useIntervalWhen instead.");
      var internalIdRef = react.useRef(null);
      var _a = react.useState(startImmediate), isRunning = _a[0], setIsRunning = _a[1];
      var savedCallback = react.useRef();
      function start() {
          if (!isRunning) {
              setIsRunning(true);
          }
      }
      function stop() {
          if (isRunning) {
              setIsRunning(false);
          }
      }
      // Remember the latest callback.
      react.useEffect(function () {
          savedCallback.current = callback;
      });
      // Set up the interval.
      react.useEffect(function () {
          function tick() {
              var _a;
              (_a = savedCallback.current) === null || _a === void 0 ? void 0 : _a.call(savedCallback);
          }
          if (intervalDuration !== null && isRunning) {
              var id_1 = setInterval(tick, intervalDuration);
              internalIdRef.current = id_1;
              return function () {
                  internalIdRef.current = null;
                  clearInterval(id_1);
              };
          }
          return noop;
      }, [intervalDuration, isRunning]);
      var handler;
      handler = [start, stop, internalIdRef.current];
      handler.start = start;
      handler.stop = stop;
      handler.intervalId = internalIdRef.current;
      return handler;
  }

  var config$2 = {
      root: null,
      rootMargin: "0px 0px 0px 0px",
      threshold: [0, 1],
  };
  /**
   *
   * useIntersectionObserverRef hook
   *
   * Returns a mutation observer for a React Ref and fires a callback
   *
   * @param {IntersectionObserverCallback} callback Function that needs to be fired on mutation
   * @param {IntersectionObserverInit} options
   */
  function useIntersectionObserverRef(callback, options) {
      if (options === void 0) { options = config$2; }
      var _a = options.root, root = _a === void 0 ? null : _a, rootMargin = options.rootMargin, threshold = options.threshold;
      var _b = react.useState(null), node = _b[0], setNode = _b[1];
      react.useEffect(function () {
          // Create an observer instance linked to the callback function
          if (node && callback) {
              var observer_1 = new IntersectionObserver(callback, options);
              // Start observing the target node for configured mutations
              observer_1.observe(node);
              return function () {
                  observer_1.disconnect();
              };
          }
          return noop;
      }, [node, callback, root, rootMargin, threshold]);
      var ref = react.useCallback(function (node) {
          setNode(node);
      }, []);
      return [ref];
  }

  var config$3 = {
      root: null,
      rootMargin: "0px 0px 0px 0px",
      threshold: [0, 1],
  };
  /**
   *
   * useInViewRef hook
   *
   * Returns a mutation observer for a React Ref and true/false when element enters/leaves the viewport. Also fires a callback.
   *
   * @param {IntersectionObserverCallback} callback Function that needs to be fired on mutation
   * @param {IntersectionObserverInit} options
   */
  function useInViewRef(callback, options) {
      if (callback === void 0) { callback = function () { }; }
      if (options === void 0) { options = config$3; }
      var _a = options.root, root = _a === void 0 ? null : _a, rootMargin = options.rootMargin, threshold = options.threshold;
      var _b = react.useState(null), node = _b[0], setNode = _b[1];
      var _c = react.useState(false), inView = _c[0], setInView = _c[1];
      react.useEffect(function () {
          // Create an observer instance linked to the callback function
          if (node) {
              var observer_1 = new IntersectionObserver(function (entries, observerRef) {
                  entries.forEach(function (_a) {
                      var isIntersecting = _a.isIntersecting;
                      return setInView(isIntersecting);
                  });
                  callback(entries, observerRef);
              }, options);
              // Start observing the target node for configured mutations
              observer_1.observe(node);
              return function () {
                  observer_1.disconnect();
              };
          }
          return noop;
      }, [node, callback, root, rootMargin, threshold]);
      var ref = react.useCallback(function (node) {
          setNode(node);
      }, []);
      return [ref, inView];
  }

  var doesIdentifierMatchKeyboardEvent = function (error, identifier) {
      if (error.key === identifier ||
          error.code === identifier ||
          error.keyCode === identifier ||
          error.which === identifier ||
          error.charCode === identifier) {
          return true;
      }
      return false;
  };

  var defaultOptions$1 = {
      eventTypes: ["keydown"],
      when: true,
  };
  /**
   * useKey hook
   *
   * Fires a callback on keyboard events like keyDown, keyPress and keyUp
   *
   * @param {TrackedKeyEvents} keys List of keys to listen for. Eg: ["a", "b"]
   * @param {Callback} callback  Callback to fire on keyboard events
   * @param {Options} options Options
   * @see {@link https://react-hooks.org/docs/useKey}
   */
  function useKey(keys, callback, options) {
      var keyList = react.useMemo(function () {
          if (Array.isArray(keys)) {
              return keys;
          }
          else {
              return [keys];
          }
      }, [keys]);
      var internalOptions = react.useMemo(function () {
          return __assign(__assign({}, defaultOptions$1), options);
      }, [options]);
      var when = internalOptions.when, eventTypes = internalOptions.eventTypes;
      var callbackRef = react.useRef(callback);
      var target = internalOptions.target;
      react.useEffect(function () {
          callbackRef.current = callback;
      });
      var handle = react.useCallback(function (event) {
          if (keyList.some(function (identifier) {
              return doesIdentifierMatchKeyboardEvent(event, identifier);
          })) {
              callbackRef.current(event);
          }
      }, [keyList]);
      react.useEffect(function () {
          if (when && typeof window !== "undefined") {
              // If target is defined by the user
              if (target) {
                  var targetNode_1 = target.current;
                  if (targetNode_1) {
                      for (var _i = 0, eventTypes_1 = eventTypes; _i < eventTypes_1.length; _i++) {
                          var eventType = eventTypes_1[_i];
                          targetNode_1.addEventListener(eventType, handle);
                      }
                      return function () {
                          for (var _i = 0, eventTypes_3 = eventTypes; _i < eventTypes_3.length; _i++) {
                              var eventType = eventTypes_3[_i];
                              targetNode_1.removeEventListener(eventType, handle);
                          }
                      };
                  }
              }
              else {
                  for (var _a = 0, eventTypes_2 = eventTypes; _a < eventTypes_2.length; _a++) {
                      var eventType = eventTypes_2[_a];
                      window.addEventListener(eventType, handle);
                  }
                  return function () {
                      for (var _i = 0, eventTypes_4 = eventTypes; _i < eventTypes_4.length; _i++) {
                          var eventType = eventTypes_4[_i];
                          window.removeEventListener(eventType, handle);
                      }
                  };
              }
          }
          return noop;
      }, [when, eventTypes, keyList, target, callback, handle]);
  }

  /**
   * useKeyBindings
   *
   * useKeyBindings binds pairs of keyboard events and handlers
   *
   * @param { KeyBindings } keyBindings
   * @param {Options} options
   * @see {@link https://react-hooks.org/docs/useKeyBindings}
   */
  var useKeyBindings = function (keyBindings, options) {
      for (var key in keyBindings) {
          // eslint-disable-next-line react-hooks/rules-of-hooks
          useKey(key, keyBindings[key], options);
      }
  };

  var defaultOptions$2 = {
      eventTypes: ["keydown"],
      when: true,
  };
  /**
   * useKeyRef hook
   *
   * Fires a callback on keyboard events like keyDown, keyPress and keyUp
   *
   * @param {[string|number]} keys List of keys to listen for. Eg: ["a", "b"]
   * @param {Function} callback Callback to fire on keyboard events
   * @param {Options} options Options
   * @returns {CallbackRef} CallbackRef
   * @see {@link https://react-hooks.org/docs/useKeyRef}
   */
  function useKeyRef(keys, callback, options) {
      var _a = react.useState(null), targetNode = _a[0], setTargetNode = _a[1];
      var ref = react.useCallback(function (node) {
          setTargetNode(node);
      }, []);
      var keyList = react.useMemo(function () {
          if (Array.isArray(keys)) {
              return keys;
          }
          else {
              return [keys];
          }
      }, [keys]);
      var internalOptions = react.useMemo(function () {
          return __assign(__assign({}, defaultOptions$2), options);
      }, [options]);
      var when = internalOptions.when, eventTypes = internalOptions.eventTypes;
      var callbackRef = react.useRef(callback);
      react.useEffect(function () {
          callbackRef.current = callback;
      });
      var handle = react.useCallback(function (event) {
          if (keyList.some(function (identifier) {
              return doesIdentifierMatchKeyboardEvent(event, identifier);
          })) {
              callbackRef.current(event);
          }
      }, [keyList]);
      react.useEffect(function () {
          if (when && targetNode) {
              for (var _i = 0, eventTypes_1 = eventTypes; _i < eventTypes_1.length; _i++) {
                  var eventType = eventTypes_1[_i];
                  // eslint-disable-next-line prefer-arrow-callback
                  targetNode.addEventListener(eventType, handle);
              }
              return function () {
                  for (var _i = 0, eventTypes_2 = eventTypes; _i < eventTypes_2.length; _i++) {
                      var eventType = eventTypes_2[_i];
                      targetNode.removeEventListener(eventType, handle);
                  }
              };
          }
          return noop;
      }, [targetNode, when, eventTypes, keyList, handle]);
      return ref;
  }

  /**
   * defaultOptions which will be merged with passed in options
   */
  var defaultOptions$3 = {
      continuous: false,
      when: true,
  };
  /**
   * useKeys hook
   *
   * @param keysList
   * @param callback
   * @param opts
   */
  function useKeys(keysList, callback, options_) {
      var options = Object.assign({}, defaultOptions$3, options_);
      var target = options.target, when = options.when, continuous = options.continuous;
      var savedCallback = react.useRef(callback);
      /**
       * PressedKeyMapping will do the bookkeeping the pressed keys
       */
      var pressedKeyMappingRef = react.useRef({});
      var PressedKeyMapping = pressedKeyMappingRef.current;
      /**
       *  First useEffect is to remember the latest callback
       */
      react.useEffect(function () {
          savedCallback.current = callback;
      });
      /**
       * handleKeyDown
       *
       * @param   {KeyboardEvent}  event
       * KeyDown event handler which will wrap the passed in callback
       */
      var handleKeyDown = react.useCallback(function (event) {
          var pressedKeyIdentifier = null;
          var areAllKeysFromListPressed = false;
          // First detect the key that was pressed;
          keysList.forEach(function (identifier) {
              if (doesIdentifierMatchKeyboardEvent(event, identifier)) {
                  PressedKeyMapping[identifier] = true;
                  pressedKeyIdentifier = identifier;
              }
          });
          if (keysList.every(function (identifier) { return Boolean(PressedKeyMapping[identifier]); })) {
              areAllKeysFromListPressed = true;
          }
          if (areAllKeysFromListPressed) {
              if (savedCallback.current) {
                  savedCallback.current(event);
              }
              /**
               * If not continuous
               * disable identifier immediately
               */
              if (!continuous && pressedKeyIdentifier !== null) {
                  PressedKeyMapping[pressedKeyIdentifier] = false;
              }
          }
      }, [keysList, continuous]);
      /**
       * [handleKeyUp]
       *
       * @param   {KeyboardEvent}  event
       *
       * KeyUp event handler which will update the keys pressed state in PressedKeyMapping
       */
      var handleKeyUp = react.useCallback(function (event) {
          keysList.forEach(function (identifier) {
              if (doesIdentifierMatchKeyboardEvent(event, identifier)) {
                  PressedKeyMapping[identifier] = undefined;
              }
          });
      }, []);
      /**
       * Responsible for setting up the event listener and removing event listeners
       */
      react.useEffect(function () {
          if (when && typeof window !== 'undefined') {
              var targetNode_1 = target && target.current ? target.current : document;
              if (targetNode_1) {
                  targetNode_1.addEventListener('keydown', handleKeyDown);
                  targetNode_1.addEventListener('keyup', handleKeyUp);
              }
              return function () {
                  if (targetNode_1) {
                      targetNode_1.removeEventListener('keydown', handleKeyDown);
                      targetNode_1.removeEventListener('keyup', handleKeyUp);
                  }
              };
          }
      }, [when, target, keysList, handleKeyDown, handleKeyUp]);
  }

  /**
   *  useDidUpdate hook
   *
   *  Fires a callback on component update
   *  Can take in a list of conditions to fire callback when one of the
   *  conditions changes
   *  Will fire callback's cleanup function on update
   *
   * @param {Function} callback The callback and its cleanup to be called on update
   * @param {Array} conditions The list of variables which trigger update when they are changed
   * @returns {}
   */
  function useUpdateEffect(callback, conditions) {
      useWarningOnMountInDevelopment("useUpdateEffect is deprecated, it will be removed in rooks v7. Please use useDidUpdate instead.");
      var hasMountedRef = react.useRef(false);
      if (typeof conditions !== "undefined" && !Array.isArray(conditions)) {
          conditions = [conditions];
      }
      else if (Array.isArray(conditions) && conditions.length === 0) {
          console.warn("Using [] as the second argument makes useUpdateEffect a noop. The second argument should either be `undefined` or an array of length greater than 0.");
      }
      react.useEffect(function () {
          if (hasMountedRef.current) {
              return callback();
          }
          else {
              hasMountedRef.current = true;
          }
      }, conditions);
  }

  /**
   * useWillUnmount hook
   * Fires a callback just before component unmounts
   *
   * @param {Function} callback Callback to be called before unmount
   */
  function useWillUnmount(callback) {
      // run only once
      react.useEffect(function () {
          return callback;
          // eslint-disable-next-line react-hooks/exhaustive-deps
      }, []);
  }

  /**
   * useLifecycleLogger hook
   * logs parameters as component transitions through lifecycles
   *
   * @param componentName Name of the component
   * @param rest
   */
  var useLifecycleLogger = function (componentName) {
      if (componentName === void 0) { componentName = "Component"; }
      var otherArgs = [];
      for (var _i = 1; _i < arguments.length; _i++) {
          otherArgs[_i - 1] = arguments[_i];
      }
      useDidMount(function () {
          console.log.apply(console, __spreadArray(["".concat(componentName, " mounted")], otherArgs, false));
          return function () { return console.log("".concat(componentName, " unmounted")); };
      });
      useUpdateEffect(function () {
          console.log.apply(console, __spreadArray(["".concat(componentName, " updated")], otherArgs, false));
      });
      useWillUnmount(function () {
          console.log("".concat(componentName, " unmounted"));
      });
  };

  /* eslint-disable sort-keys-fix/sort-keys-fix */
  /**
   * useLocalstorage hook
   * Tracks a value within localStorage and updates it
   *
   * @param {string} key - Key of the localStorage object
   * @param {any} defaultValue - Default initial value
   */
  function useLocalstorage(key, defaultValue) {
      if (defaultValue === void 0) { defaultValue = null; }
      var _a = react.useState(getValueFromLocalStorage()), value = _a[0], setValue = _a[1];
      useWarningOnMountInDevelopment("useLocalstorage is deprecated, it will be removed in the next major release. Please use useLocalstorageState instead.");
      function init() {
          var valueLoadedFromLocalStorage = getValueFromLocalStorage();
          if (valueLoadedFromLocalStorage === null ||
              valueLoadedFromLocalStorage === "null") {
              set(defaultValue);
          }
      }
      function getValueFromLocalStorage() {
          if (typeof localStorage === "undefined") {
              return null;
          }
          var storedValue = localStorage.getItem(key) || "null";
          try {
              return JSON.parse(storedValue);
          }
          catch (error) {
              console.error(error);
          }
          return storedValue;
      }
      function saveValueToLocalStorage(valueToSet) {
          if (typeof localStorage === "undefined") {
              return null;
          }
          return localStorage.setItem(key, JSON.stringify(valueToSet));
      }
      var set = react.useCallback(function (newValue) {
          setValue(newValue);
          saveValueToLocalStorage(newValue);
      }, []);
      var listen = react.useCallback(function (event) {
          if (event.storageArea === localStorage && event.key === key) {
              setValue(event.newValue);
          }
      }, []);
      // eslint-disable-next-line consistent-return
      var remove = react.useCallback(function () {
          set(null);
          if (typeof localStorage === "undefined") {
              return false;
          }
          localStorage.removeItem(key);
          return undefined;
      }, [key]);
      // initialize
      react.useEffect(function () {
          init();
      }, []);
      // check for changes across windows
      react.useEffect(function () {
          if (typeof window !== "undefined") {
              window.addEventListener("storage", listen);
              return function () {
                  window.removeEventListener("storage", listen);
              };
          }
          else {
              console.warn("useLocalstorage: window is undefined.");
          }
          return noop;
      }, []);
      var handler = Object.assign([value, set, remove], {
          value: value,
          remove: remove,
          set: set,
      });
      return handler;
  }

  // Gets value from localstorage
  function getValueFromLocalStorage(key) {
      var _a;
      if (typeof localStorage === "undefined") {
          return null;
      }
      var storedValue = (_a = localStorage.getItem(key)) !== null && _a !== void 0 ? _a : "null";
      try {
          return JSON.parse(storedValue);
      }
      catch (error) {
          console.error(error);
      }
      return storedValue;
  }
  // Saves value to localstorage
  function saveValueToLocalStorage(key, value) {
      if (typeof localStorage === "undefined") {
          return null;
      }
      return localStorage.setItem(key, JSON.stringify(value));
  }
  /**
   * @param key Key of the localStorage object
   * @param initialState Default initial value
   */
  function initialize(key, initialState) {
      var valueLoadedFromLocalStorage = getValueFromLocalStorage(key);
      if (valueLoadedFromLocalStorage === null) {
          return initialState;
      }
      else {
          return valueLoadedFromLocalStorage;
      }
  }
  /**
   * useLocalstorageState hook
   * Tracks a value within localStorage and updates it
   *
   * @param {string} key - Key of the localStorage object
   * @param {any} initialState - Default initial value
   */
  function useLocalstorageState(key, initialState) {
      var _a = react.useState(function () { return initialize(key, initialState); }), value = _a[0], setValue = _a[1];
      var isUpdateFromCrossDocumentListener = react.useRef(false);
      var isUpdateFromWithinDocumentListener = react.useRef(false);
      var customEventTypeName = react.useMemo(function () {
          return "rooks-".concat(key, "-localstorage-update");
      }, [key]);
      react.useEffect(function () {
          /**
           * We need to ensure there is no loop of
           * storage events fired. Hence we are using a ref
           * to keep track of whether setValue is from another
           * storage event
           */
          if (!isUpdateFromCrossDocumentListener.current ||
              !isUpdateFromWithinDocumentListener.current) {
              saveValueToLocalStorage(key, value);
          }
      }, [key, value]);
      var listenToCrossDocumentStorageEvents = react.useCallback(function (event) {
          var _a;
          if (event.storageArea === localStorage && event.key === key) {
              try {
                  isUpdateFromCrossDocumentListener.current = true;
                  var newValue = JSON.parse((_a = event.newValue) !== null && _a !== void 0 ? _a : "null");
                  if (value !== newValue) {
                      setValue(newValue);
                  }
              }
              catch (error) {
                  console.log(error);
              }
          }
      }, [key, value]);
      // check for changes across documents
      react.useEffect(function () {
          // eslint-disable-next-line no-negated-condition
          if (typeof window !== "undefined") {
              window.addEventListener("storage", listenToCrossDocumentStorageEvents);
              return function () {
                  window.removeEventListener("storage", listenToCrossDocumentStorageEvents);
              };
          }
          else {
              console.warn("useLocalstorageState: window is undefined.");
              return function () { };
          }
      }, [listenToCrossDocumentStorageEvents]);
      var listenToCustomEventWithinDocument = react.useCallback(function (event) {
          try {
              isUpdateFromWithinDocumentListener.current = true;
              var newValue = event.detail.newValue;
              if (value !== newValue) {
                  setValue(newValue);
              }
          }
          catch (error) {
              console.log(error);
          }
      }, [value]);
      // check for changes within document
      react.useEffect(function () {
          // eslint-disable-next-line no-negated-condition
          if (typeof document !== "undefined") {
              document.addEventListener(customEventTypeName, listenToCustomEventWithinDocument);
              return function () {
                  document.removeEventListener(customEventTypeName, listenToCustomEventWithinDocument);
              };
          }
          else {
              console.warn("[useLocalstorageState] document is undefined.");
              return function () { };
          }
      }, [customEventTypeName, listenToCustomEventWithinDocument]);
      var broadcastValueWithinDocument = react.useCallback(function (newValue) {
          // eslint-disable-next-line no-negated-condition
          if (typeof document !== "undefined") {
              var event_1 = new CustomEvent(customEventTypeName, { detail: { newValue: newValue } });
              document.dispatchEvent(event_1);
          }
          else {
              console.warn("[useLocalstorageState] document is undefined.");
          }
      }, [customEventTypeName]);
      var set = react.useCallback(function (newValue) {
          isUpdateFromCrossDocumentListener.current = false;
          isUpdateFromWithinDocumentListener.current = false;
          setValue(newValue);
          broadcastValueWithinDocument(newValue);
      }, [broadcastValueWithinDocument]);
      var remove = react.useCallback(function () {
          localStorage.removeItem(key);
      }, [key]);
      return [value, set, remove];
  }

  /**
   * useMapState hook
   * A hook to manage state in the form of a map or object.
   *
   * @param initialValue Initial value of the map
   */
  function useMapState(initialValue) {
      var _a = react.useState(initialValue), map = _a[0], setMap = _a[1];
      var set = react.useCallback(function (key, value) {
          setMap(function (currentMap) {
              var _a;
              return (__assign(__assign({}, currentMap), (_a = {}, _a[key] = value, _a)));
          });
      }, []);
      var has = react.useCallback(function (key) {
          return typeof map[key] !== "undefined";
      }, [map]);
      var setMultiple = react.useCallback(function (nextMap) {
          setMap(function (currentMap) { return (__assign(__assign({}, currentMap), nextMap)); });
      }, []);
      var removeMultiple = react.useCallback(function () {
          var keys = [];
          for (var _i = 0; _i < arguments.length; _i++) {
              keys[_i] = arguments[_i];
          }
          setMap(function (currentMap) {
              var nextMap = __assign({}, currentMap);
              for (var _i = 0, keys_1 = keys; _i < keys_1.length; _i++) {
                  var key = keys_1[_i];
                  delete nextMap[key];
              }
              return nextMap;
          });
      }, [setMap]);
      var remove = react.useCallback(function (key) {
          setMap(function (currentMap) {
              var nextMap = __assign({}, currentMap);
              delete nextMap[key];
              return nextMap;
          });
      }, [setMap]);
      var removeAll = react.useCallback(function () {
          setMap(function (currentMap) {
              var nextMap = __assign({}, currentMap);
              for (var key in nextMap) {
                  delete nextMap[key];
              }
              return nextMap;
          });
      }, [setMap]);
      return [
          map,
          {
              has: has,
              remove: remove,
              removeAll: removeAll,
              removeMultiple: removeMultiple,
              set: set,
              setMultiple: setMultiple,
          },
      ];
  }

  /**
   * useMediaMatch
   *
   * A react hook that signals whether or not a media query is matched.
   *
   * @param query The media query to signal on. Example, `"print"` will signal
   * `true` when previewing in print mode, and `false` otherwise.
   * @returns Whether or not the media query is currently matched.
   */
  function useMediaMatch(query) {
      if (typeof window === "undefined") {
          console.warn("useMediaMatch cannot function as window is undefined.");
          return false;
      }
      var matchMedia = react.useMemo(function () { return window.matchMedia(query); }, [query]);
      var _a = react.useState(function () { return matchMedia.matches; }), matches = _a[0], setMatches = _a[1];
      react.useEffect(function () {
          setMatches(matchMedia.matches);
          var listener = function (event_) {
              return setMatches(event_.matches);
          };
          if (matchMedia.addEventListener) {
              matchMedia.addEventListener("change", listener);
              return function () { return matchMedia.removeEventListener("change", listener); };
          }
          else {
              matchMedia.addListener(listener);
              return function () { return matchMedia.removeListener(listener); };
          }
      }, [matchMedia]);
      return matches;
  }

  function setRef$1(ref, value) {
      if (typeof ref === "function") {
          ref(value);
      }
      else if (ref) {
          ref.current = value;
      }
  }
  /**
   * useMergeRefs
   * Merges multiple refs into a single function ref.
   * Takes any number of refs.
   * Refs can be mutable refs or function refs.
   *
   * @param refs
   */
  function useMergeReferences() {
      var references = [];
      for (var _i = 0; _i < arguments.length; _i++) {
          references[_i] = arguments[_i];
      }
      return react.useMemo(function () {
          if (references.every(function (ref) { return ref === null; })) {
              return null;
          }
          return function (refValue) {
              references.forEach(function (ref) {
                  setRef$1(ref, refValue);
              });
          };
      }, __spreadArray([], references, true));
  }

  var initialMouseState = {
      clientX: null,
      clientY: null,
      movementX: null,
      movementY: null,
      offsetX: null,
      offsetY: null,
      pageX: null,
      pageY: null,
      screenX: null,
      screenY: null,
      x: null,
      y: null,
  };
  function getMousePositionFromEvent(e) {
      var screenX = e.screenX, screenY = e.screenY, movementX = e.movementX, movementY = e.movementY, pageX = e.pageX, pageY = e.pageY, clientX = e.clientX, clientY = e.clientY, offsetX = e.offsetX, offsetY = e.offsetY;
      return {
          clientX: clientX,
          clientY: clientY,
          movementX: movementX,
          movementY: movementY,
          offsetX: offsetX,
          offsetY: offsetY,
          pageX: pageX,
          pageY: pageY,
          screenX: screenX,
          screenY: screenY,
          x: screenX,
          y: screenY,
      };
  }
  /**
   * useMouse hook
   *
   * Retrieves current mouse position and information about the position like
   * screenX, pageX, clientX, movementX, offsetX
   */
  function useMouse() {
      var _a = react.useState(initialMouseState), mousePosition = _a[0], setMousePostition = _a[1];
      function updateMousePosition(e) {
          setMousePostition(getMousePositionFromEvent(e));
      }
      react.useEffect(function () {
          document.addEventListener("mousemove", updateMousePosition);
          return function () {
              document.removeEventListener("mousemove", updateMousePosition);
          };
      }, []);
      return mousePosition;
  }

  function warnIfBothValueAndIndexAreProvided(functionName, object) {
      if (Object.values(object).every(function (value) { return typeof value !== "undefined"; })) {
          console.warn("".concat(functionName, ". Expected either ").concat(Object.keys(object).join(" or "), " to be provided. However all were provided"));
      }
      else if (Object.values(object).every(function (value) { return typeof value === "undefined"; })) {
          console.warn("".concat(functionName, ". ").concat(Object.keys(object).join(" , "), " are all undefined."));
      }
  }
  /**
   * useMultiSelectableList
   * A custom hook to easily select multiple values from a list
   *
   * @param list - The list of values to select from
   * @param initialSelectIndices - The indices of the initial selections
   * @param allowUnselected - Whether or not to allow unselected values
   * @see {@link https://react-hooks.org/docs/useMultiSelectableList}
   */
  function useMultiSelectableList(list, initialSelectIndices, allowUnselected) {
      if (list === void 0) { list = []; }
      if (initialSelectIndices === void 0) { initialSelectIndices = [0]; }
      if (allowUnselected === void 0) { allowUnselected = false; }
      var _a = react.useState(initialSelectIndices), currentIndices = _a[0], setCurrentIndices = _a[1];
      var currentValues = currentIndices.map(function (index) { return list[index]; });
      var selection = [currentIndices, currentValues];
      var updateSelections = function (_a) {
          var indices = _a.indices, values = _a.values;
          return function () {
              warnIfBothValueAndIndexAreProvided("updateSelections", {
                  indices: indices,
                  values: values,
              });
              if (typeof indices !== "undefined") {
                  if (!allowUnselected && indices.length === 0) {
                      console.warn("updateSelections failed. indices is an empty list.");
                      return;
                  }
                  setCurrentIndices(indices);
              }
              else if (typeof values !== "undefined") {
                  // eslint-disable-next-line unicorn/no-array-reduce
                  var valueIndices = list.reduce(function (accumulator, current, index) {
                      if (values.includes(current)) {
                          var array = __spreadArray(__spreadArray([], accumulator, true), [index], false);
                          return array;
                      }
                      return accumulator;
                  }, []);
                  if (valueIndices.length > 0) {
                      setCurrentIndices(valueIndices);
                  }
                  else if (allowUnselected) {
                      setCurrentIndices(valueIndices);
                  }
                  else {
                      console.warn("updateSelections failed. Do the values exist in the list?");
                  }
              }
          };
      };
      var toggleSelectionByIndex = react.useCallback(function (index) {
          var newIndices;
          if (!currentIndices.includes(index)) {
              newIndices = __spreadArray(__spreadArray([], currentIndices, true), [index], false);
          }
          else {
              newIndices = __spreadArray([], currentIndices, true);
              var indexOfIndex = currentIndices.indexOf(index);
              if (indexOfIndex !== -1) {
                  newIndices.splice(indexOfIndex, 1);
              }
          }
          if (newIndices.length > 0) {
              setCurrentIndices(newIndices);
          }
          else if (allowUnselected) {
              setCurrentIndices(newIndices);
          }
          else {
              console.warn("toggleSelection failed. Do the values exist in the list?");
          }
      }, [allowUnselected, currentIndices]);
      var toggleSelection = react.useCallback(function (_a) {
          var index = _a.index, value = _a.value;
          return function () {
              warnIfBothValueAndIndexAreProvided("toggleSelection", {
                  index: index,
                  value: value,
              });
              if (typeof index !== "undefined") {
                  toggleSelectionByIndex(index);
              }
              else if (typeof value !== "undefined") {
                  var valueIndex = list.indexOf(value);
                  if (valueIndex > -1) {
                      toggleSelectionByIndex(valueIndex);
                  }
              }
          };
      }, [list, toggleSelectionByIndex]);
      var matchSelection = react.useCallback(function (_a) {
          var index = _a.index, value = _a.value;
          warnIfBothValueAndIndexAreProvided("matchSelection", { index: index, value: value });
          if (typeof index !== "undefined") {
              return currentIndices.includes(index);
          }
          else if (typeof value !== "undefined") {
              return currentValues.includes(value);
          }
          return false;
      }, [currentIndices, currentValues]);
      var controls = {
          matchSelection: matchSelection,
          toggleSelection: toggleSelection,
          updateSelections: updateSelections,
      };
      return [selection, controls];
  }

  /**
   *  useWindowEventListener hook
   *
   *  A react hook to an event listener to the window
   *
   * @param {string} eventName The event to track
   * @param {Function} callback The callback to be called on event
   * @param {ListenerOptions} listenerOptions The options to be passed to the event listener
   * @param {boolean} isLayoutEffect Should it use layout effect. Defaults to false
   * @returns {undefined}
   */
  function useWindowEventListener(eventName, callback, listenerOptions, isLayoutEffect) {
      if (listenerOptions === void 0) { listenerOptions = {}; }
      if (isLayoutEffect === void 0) { isLayoutEffect = false; }
      useGlobalObjectEventListener(window, eventName, callback, listenerOptions, true, isLayoutEffect);
  }

  function getLanguage() {
      // eslint-disable-next-line no-negated-condition
      if (typeof navigator !== "undefined") {
          // @ts-expect-error - This is a valid type for the navigator object in IE
          // eslint-disable-next-line @typescript-eslint/dot-notation
          return navigator.language || navigator["userLanguage"];
      }
      else {
          return null;
      }
  }
  /**
   * useNavigatorLanguage hook
   * Returns the language of the navigator
   *
   * @returns {Language}
   * @see {@link https://react-hooks.org/docs/useNavigatorLanguage}
   */
  function useNavigatorLanguage() {
      var _a = react.useState(getLanguage), language = _a[0], setLanguage = _a[1];
      useWindowEventListener("languagechange", function () {
          setLanguage(getLanguage);
      });
      return language;
  }

  /**
   *
   * @returns {boolean} Is navigator online
   */
  function getIsOnline() {
      if (typeof window === "undefined") {
          return null;
      }
      return navigator.onLine;
  }
  /**
   * useOnline hook
   *
   * Returns true if navigator is online, false if not.
   *
   * @returns {boolean} The value of navigator.onLine
   */
  function useOnline() {
      var _a = react.useState(function () { return getIsOnline(); }), isOnline = _a[0], setIsOnline = _a[1];
      function setOffline() {
          setIsOnline(false);
      }
      function setOnline() {
          setIsOnline(true);
      }
      // we only needs this to be set on mount
      // hence []
      react.useEffect(function () {
          // eslint-disable-next-line no-negated-condition
          if (typeof window !== "undefined") {
              window.addEventListener("online", setOnline);
              window.addEventListener("offline", setOffline);
              return function () {
                  window.removeEventListener("online", setOnline);
                  window.removeEventListener("offline", setOffline);
              };
          }
          else {
              console.warn("useOnline: window is undefined.");
              return noop;
          }
      }, []);
      return isOnline;
  }

  /**
   *  useOutsideClick hook
   * Checks if a click happened outside a Ref. Handy for dropdowns, modals and popups etc.
   *
   * @param ref Ref whose outside click needs to be listened to
   * @param handler Callback to fire on outside click
   * @param when A boolean which which activates the hook only when it is true. Useful for conditionally enable the outside click
   */
  function useOutsideClick(ref, handler, when) {
      if (when === void 0) { when = true; }
      var savedHandler = react.useRef(handler);
      var memoizedCallback = react.useCallback(function (e) {
          if (ref && ref.current && !ref.current.contains(e.target)) {
              savedHandler.current(e);
          }
      }, []);
      react.useEffect(function () {
          savedHandler.current = handler;
      });
      react.useEffect(function () {
          if (when) {
              document.addEventListener("click", memoizedCallback, true);
              document.addEventListener("ontouchstart", memoizedCallback, true);
              return function () {
                  document.removeEventListener("click", memoizedCallback, true);
                  document.removeEventListener("ontouchstart", memoizedCallback, true);
              };
          }
          return noop;
      }, [ref, handler, when]);
  }

  /**
   * useOutsideClickRef hook
   * Checks if a click happened outside a Ref. Handy for dropdowns, modals and popups etc.
   *
   * @param handler Callback to fire on outside click
   * @param when A boolean which which activates the hook only when it is true. Useful for conditionally enable the outside click
   * @returns An array with first item being ref
   */
  function useOutsideClickRef(handler, when) {
      if (when === void 0) { when = true; }
      var savedHandler = react.useRef(handler);
      var _a = react.useState(null), node = _a[0], setNode = _a[1];
      var memoizedCallback = react.useCallback(function (e) {
          if (node && !node.contains(e.target)) {
              savedHandler.current(e);
          }
      }, [node]);
      react.useEffect(function () {
          savedHandler.current = handler;
      });
      var ref = react.useCallback(function (node) {
          setNode(node);
      }, []);
      react.useEffect(function () {
          if (when) {
              document.addEventListener("click", memoizedCallback, true);
              document.addEventListener("ontouchstart", memoizedCallback, true);
              return function () {
                  document.removeEventListener("click", memoizedCallback, true);
                  document.removeEventListener("ontouchstart", memoizedCallback, true);
              };
          }
          return noop;
      }, [when, memoizedCallback]);
      return [ref];
  }

  /**
   * usePrevious hook for React
   *
   * @param currentValue The value whose previous value is to be tracked
   * @returns The previous value
   */
  function usePrevious(currentValue) {
      useWarningOnMountInDevelopment("usePrevious is deprecated, it will be removed in rooks v7. Please use usePreviousImmediate instead.");
      var previousRef = react.useRef(null);
      react.useEffect(function () {
          previousRef.current = currentValue;
      }, [currentValue]);
      return previousRef.current;
  }

  /**
   * usePreviousDifferent hook for React
   * It returns the past value which was different from the current one.
   *
   * @param currentValue The value whose previously different value is to be tracked
   * @returns The previous value
   */
  function usePreviousDifferent(currentValue) {
      var previousRef = react.useRef(null);
      var previousRef2 = react.useRef(null);
      react.useEffect(function () {
          previousRef2.current = previousRef.current;
          previousRef.current = currentValue;
      }, [currentValue]);
      return currentValue === previousRef.current
          ? previousRef2.current
          : previousRef.current;
  }

  /**
   * usePreviousImmediate hook for React
   *
   * @param currentValue The value whose previous value is to be tracked
   * @returns The previous value
   */
  function usePreviousImmediate(currentValue) {
      var previousRef = react.useRef(null);
      react.useEffect(function () {
          previousRef.current = currentValue;
      });
      return previousRef.current;
  }

  function useQueueState(initialList) {
      var _a = react.useState(__spreadArray([], initialList, true)), list = _a[0], setList = _a[1];
      var enqueue = react.useCallback(function (item) {
          var newList = __spreadArray(__spreadArray([], list, true), [item], false);
          setList(newList);
          return newList.length;
      }, [list]);
      var dequeue = react.useCallback(function () {
          if (list.length > 0) {
              var firstItem = list[0];
              setList(__spreadArray([], list.slice(1), true));
              return firstItem;
          }
          return undefined;
      }, [list]);
      var peek = react.useCallback(function () {
          if (list.length > 0) {
              return list[0];
          }
          return undefined;
      }, [list]);
      var controls = {
          dequeue: dequeue,
          enqueue: enqueue,
          length: list.length,
          peek: peek,
      };
      return [list, controls];
  }

  function createCommonjsModule(fn) {
    var module = { exports: {} };
  	return fn(module, module.exports), module.exports;
  }

  var performanceNow = createCommonjsModule(function (module) {
  // Generated by CoffeeScript 1.12.2
  (function() {
    var getNanoSeconds, hrtime, loadTime, moduleLoadTime, nodeLoadTime, upTime;

    if ((typeof performance !== "undefined" && performance !== null) && performance.now) {
      module.exports = function() {
        return performance.now();
      };
    } else if ((typeof process !== "undefined" && process !== null) && process.hrtime) {
      module.exports = function() {
        return (getNanoSeconds() - nodeLoadTime) / 1e6;
      };
      hrtime = process.hrtime;
      getNanoSeconds = function() {
        var hr;
        hr = hrtime();
        return hr[0] * 1e9 + hr[1];
      };
      moduleLoadTime = getNanoSeconds();
      upTime = process.uptime() * 1e9;
      nodeLoadTime = moduleLoadTime - upTime;
    } else if (Date.now) {
      module.exports = function() {
        return Date.now() - loadTime;
      };
      loadTime = Date.now();
    } else {
      module.exports = function() {
        return new Date().getTime() - loadTime;
      };
      loadTime = new Date().getTime();
    }

  }).call(this);


  });

  var root$1 = typeof window === 'undefined' ? global : window
    , vendors = ['moz', 'webkit']
    , suffix = 'AnimationFrame'
    , raf = root$1['request' + suffix]
    , caf = root$1['cancel' + suffix] || root$1['cancelRequest' + suffix];

  for(var i = 0; !raf && i < vendors.length; i++) {
    raf = root$1[vendors[i] + 'Request' + suffix];
    caf = root$1[vendors[i] + 'Cancel' + suffix]
        || root$1[vendors[i] + 'CancelRequest' + suffix];
  }

  // Some versions of FF have rAF but not cAF
  if(!raf || !caf) {
    var last = 0
      , id = 0
      , queue = []
      , frameDuration = 1000 / 60;

    raf = function(callback) {
      if(queue.length === 0) {
        var _now = performanceNow()
          , next = Math.max(0, frameDuration - (_now - last));
        last = next + _now;
        setTimeout(function() {
          var cp = queue.slice(0);
          // Clear queue here to prevent
          // callbacks from appending listeners
          // to the current frame's queue
          queue.length = 0;
          for(var i = 0; i < cp.length; i++) {
            if(!cp[i].cancelled) {
              try{
                cp[i].callback(last);
              } catch(e) {
                setTimeout(function() { throw e }, 0);
              }
            }
          }
        }, Math.round(next));
      }
      queue.push({
        handle: ++id,
        callback: callback,
        cancelled: false
      });
      return id
    };

    caf = function(handle) {
      for(var i = 0; i < queue.length; i++) {
        if(queue[i].handle === handle) {
          queue[i].cancelled = true;
        }
      }
    };
  }

  var raf_1 = function(fn) {
    // Wrap in a new function to prevent
    // `cancel` potentially being assigned
    // to the native rAF function
    return raf.call(root$1, fn)
  };
  var cancel = function() {
    caf.apply(root$1, arguments);
  };
  var polyfill = function(object) {
    if (!object) {
      object = root$1;
    }
    object.requestAnimationFrame = raf;
    object.cancelAnimationFrame = caf;
  };
  raf_1.cancel = cancel;
  raf_1.polyfill = polyfill;

  /**
   *
   * useRaf
   * Uses a polyfilled version of requestAnimationFrame
   *
   * @param {Function} callback The callback function to be executed
   * @param {boolean} [isActive] The value which while true, keeps the raf running infinitely
   * @see {@link https://react-hooks.org/docs/useRaf}
   */
  function useRaf(callback, isActive) {
      var savedCallback = react.useRef();
      // Remember the latest function.
      react.useEffect(function () {
          savedCallback.current = callback;
      }, [callback]);
      react.useEffect(function () {
          var animationFrame;
          var startTime = Date.now();
          function tick() {
              var _a;
              var timeElapsed = Date.now() - startTime;
              startTime = Date.now();
              loop();
              (_a = savedCallback.current) === null || _a === void 0 ? void 0 : _a.call(savedCallback, timeElapsed);
          }
          function loop() {
              animationFrame = raf_1(tick);
          }
          if (isActive) {
              startTime = Date.now();
              loop();
              return function () {
                  if (animationFrame) {
                      raf_1.cancel(animationFrame);
                  }
              };
          }
          else {
              return noop;
          }
      }, [isActive]);
  }

  /**
   * useSelect hook
   * Helps easily select a value from a list of values
   *
   * @param list List of values to select a value from
   * @param [initialIndex=0] Initial index which is selected
   * @returns handler
   */
  function useSelect(list, initialIndex) {
      if (initialIndex === void 0) { initialIndex = 0; }
      var _a = react.useState(initialIndex), selectedIndex = _a[0], setSelectedIndex = _a[1];
      var setItem = react.useCallback(function (item) {
          setSelectedIndex(list.indexOf(item));
      }, [list]);
      return {
          index: selectedIndex,
          item: list[selectedIndex],
          setIndex: setSelectedIndex,
          setItem: setItem,
      };
  }

  /* eslint-disable no-negated-condition */
  function warnIfBothValueAndIndexAreProvided$1(functionName, object) {
      if (Object.values(object).every(function (value) { return typeof value !== "undefined"; })) {
          console.warn("".concat(functionName, ". Expected either ").concat(Object.keys(object).join(" or "), " to be provided. However all were provided"));
      }
      else if (Object.values(object).every(function (value) { return typeof value === "undefined"; })) {
          console.warn("".concat(functionName, ". ").concat(Object.keys(object).join(" , "), " are all undefined."));
      }
  }
  /**
   * useSelectableList
   * Easily select a single value from a list of values. very useful for radio buttons, select inputs  etc.
   *
   * @param list - The list of values to select from
   * @param initialIndex  - The index of the initial selection
   * @param allowUnselected
   * @see {@link https://react-hooks.org/docs/useSelectableList}
   */
  function useSelectableList(list, initialIndex, allowUnselected) {
      if (list === void 0) { list = []; }
      if (initialIndex === void 0) { initialIndex = 0; }
      if (allowUnselected === void 0) { allowUnselected = false; }
      var _a = react.useState(initialIndex), currentIndex = _a[0], setCurrentIndex = _a[1];
      var currentValue = list[currentIndex];
      var selection = [currentIndex, currentValue];
      var updateSelection = react.useCallback(function (_a) {
          var index = _a.index, value = _a.value;
          return function () {
              warnIfBothValueAndIndexAreProvided$1("updateSelection", { index: index, value: value });
              if (typeof index !== "undefined") {
                  setCurrentIndex(index);
              }
              else if (typeof value !== "undefined") {
                  var valueIndex = list.indexOf(value);
                  if (valueIndex > -1) {
                      setCurrentIndex(valueIndex);
                  }
                  else {
                      console.warn("updateSelection failed. Does the value ".concat(value, " exist in the list?"));
                  }
              }
          };
      }, [list]);
      var toggleSelection = react.useCallback(function (_a) {
          var index = _a.index, value = _a.value;
          return function () {
              warnIfBothValueAndIndexAreProvided$1("toggleSelection", { index: index, value: value });
              if (typeof index !== "undefined") {
                  if (currentIndex === index) {
                      if (allowUnselected) {
                          setCurrentIndex(-1);
                      }
                      else {
                          console.warn("allowUnselected is false. Cannot unselect item");
                      }
                  }
                  else {
                      setCurrentIndex(index);
                  }
              }
              else if (typeof value !== "undefined") {
                  var valueIndex = list.indexOf(value);
                  if (valueIndex > -1) {
                      if (currentIndex === valueIndex) {
                          if (allowUnselected) {
                              setCurrentIndex(-1);
                          }
                          else {
                              console.warn("allowUnselected is false. Cannot unselect item");
                          }
                      }
                      else {
                          setCurrentIndex(valueIndex);
                      }
                  }
                  else {
                      console.log("as");
                      console.warn("toggleSelection failed. Does the value ".concat(value, " exist in the list?"));
                  }
              }
          };
      }, [allowUnselected, currentIndex, list]);
      var matchSelection = react.useCallback(function (_a) {
          var index = _a.index, value = _a.value;
          warnIfBothValueAndIndexAreProvided$1("matchSelection", { index: index, value: value });
          if (typeof index !== "undefined") {
              return index === currentIndex;
          }
          else {
              return value === currentValue;
          }
      }, [currentIndex, currentValue]);
      var controls = {
          matchSelection: matchSelection,
          toggleSelection: toggleSelection,
          updateSelection: updateSelection,
      };
      return [selection, controls];
  }

  /**
   * useSessionstorage
   * Tracks a value within sessionStorage and updates it
   *
   * @param key Key of the value to be stored
   * @param defaultValue Default value of the stored item
   * @see {@link https://react-hooks.org/docs/useSessionstorage}
   */
  function useSessionstorage(key, defaultValue) {
      if (defaultValue === void 0) { defaultValue = null; }
      useWarningOnMountInDevelopment("useSessionstorage is deprecated, it will be removed in the next major release. Please use useSessionstorageState instead.");
      var parseJSONString = react.useCallback(function (valueToParse) {
          if (!valueToParse) {
              return null;
          }
          try {
              return JSON.parse(valueToParse);
          }
          catch (_a) {
              return valueToParse;
          }
      }, []);
      var getValueFromSessionStorage = react.useCallback(function () {
          var _a;
          if (typeof sessionStorage === "undefined") {
              return null;
          }
          var storedValue = (_a = sessionStorage.getItem(key)) !== null && _a !== void 0 ? _a : "null";
          return parseJSONString(storedValue);
      }, [key, parseJSONString]);
      var _a = react.useState(getValueFromSessionStorage()), value = _a[0], setValue = _a[1];
      var saveValueToSessionStorage = react.useCallback(function (valueToSet) {
          if (typeof sessionStorage === "undefined") {
              return null;
          }
          return sessionStorage.setItem(key, JSON.stringify(valueToSet));
      }, [key]);
      var set = react.useCallback(function (newValue) {
          saveValueToSessionStorage(newValue);
          setValue(newValue);
      }, [saveValueToSessionStorage, setValue]);
      // eslint-disable-next-line consistent-return
      function remove() {
          if (typeof sessionStorage === "undefined") {
              return null;
          }
          sessionStorage.removeItem(key);
          setValue(null);
          return undefined;
      }
      function init() {
          var initialValue = getValueFromSessionStorage();
          if (initialValue === null ||
              initialValue === "null") {
              set(defaultValue);
          }
      }
      useDidMount(function () {
          init();
      });
      var listen = react.useCallback(function (event) {
          if (event.storageArea === sessionStorage && event.key === key) {
              set(parseJSONString(event.newValue));
          }
      }, [key, parseJSONString, set]);
      react.useEffect(function () {
          window.addEventListener("storage", listen);
          return function () {
              window.removeEventListener("storage", listen);
          };
      }, [listen]);
      var handler = Object.assign([value, set, remove], {
          remove: remove,
          set: set,
          value: value,
      });
      return handler;
  }

  function getValueFromSessionStorage(key) {
      var _a;
      if (typeof sessionStorage === "undefined") {
          return null;
      }
      var storedValue = (_a = sessionStorage.getItem(key)) !== null && _a !== void 0 ? _a : "null";
      try {
          return JSON.parse(storedValue);
      }
      catch (error) {
          console.error(error);
      }
      return storedValue;
  }
  function saveValueToSessionStorage(key, value) {
      if (typeof sessionStorage === "undefined") {
          return null;
      }
      return sessionStorage.setItem(key, JSON.stringify(value));
  }
  /**
   * @param key Key of the sessionStorage object
   * @param initialState Default initial value
   */
  function initialize$1(key, initialState) {
      var valueLoadedFromSessionStorage = getValueFromSessionStorage(key);
      if (valueLoadedFromSessionStorage === null) {
          return initialState;
      }
      else {
          return valueLoadedFromSessionStorage;
      }
  }
  /**
   * useSessionstorageState hook
   * Tracks a value within sessionStorage and updates it
   *
   * @param {string} key - Key of the sessionStorage object
   * @param {any} initialState - Default initial value
   */
  function useSessionstorageState(key, initialState) {
      var _a = react.useState(function () { return initialize$1(key, initialState); }), value = _a[0], setValue = _a[1];
      var isUpdateFromCrossDocumentListener = react.useRef(false);
      var isUpdateFromWithinDocumentListener = react.useRef(false);
      var customEventTypeName = react.useMemo(function () {
          return "rooks-".concat(key, "-sessionstorage-update");
      }, [key]);
      react.useEffect(function () {
          /**
           * We need to ensure there is no loop of
           * storage events fired. Hence we are using a ref
           * to keep track of whether setValue is from another
           * storage event
           */
          if (!isUpdateFromCrossDocumentListener.current) {
              saveValueToSessionStorage(key, value);
          }
      }, [key, value]);
      var listenToCrossDocumentStorageEvents = react.useCallback(function (event) {
          var _a;
          if (event.storageArea === sessionStorage && event.key === key) {
              try {
                  isUpdateFromCrossDocumentListener.current = true;
                  var newValue = JSON.parse((_a = event.newValue) !== null && _a !== void 0 ? _a : "null");
                  if (value !== newValue) {
                      setValue(newValue);
                  }
              }
              catch (error) {
                  console.log(error);
              }
          }
      }, [key, value]);
      // check for changes across windows
      react.useEffect(function () {
          // eslint-disable-next-line no-negated-condition
          if (typeof window !== "undefined") {
              window.addEventListener("storage", listenToCrossDocumentStorageEvents);
              return function () {
                  window.removeEventListener("storage", listenToCrossDocumentStorageEvents);
              };
          }
          else {
              console.warn("[useSessionstorageState] window is undefined.");
              return function () { };
          }
      }, [listenToCrossDocumentStorageEvents]);
      var listenToCustomEventWithinDocument = react.useCallback(function (event) {
          try {
              isUpdateFromWithinDocumentListener.current = true;
              var newValue = event.detail.newValue;
              if (value !== newValue) {
                  setValue(newValue);
              }
          }
          catch (error) {
              console.log(error);
          }
      }, [value]);
      // check for changes within document
      react.useEffect(function () {
          // eslint-disable-next-line no-negated-condition
          if (typeof document !== "undefined") {
              document.addEventListener(customEventTypeName, listenToCustomEventWithinDocument);
              return function () {
                  document.removeEventListener(customEventTypeName, listenToCustomEventWithinDocument);
              };
          }
          else {
              console.warn("[useSessionstorageState] document is undefined.");
              return function () { };
          }
      }, [customEventTypeName, listenToCustomEventWithinDocument]);
      var broadcastValueWithinDocument = react.useCallback(function (newValue) {
          // eslint-disable-next-line no-negated-condition
          if (typeof document !== "undefined") {
              var event_1 = new CustomEvent(customEventTypeName, { detail: { newValue: newValue } });
              document.dispatchEvent(event_1);
          }
          else {
              console.warn("[useSessionstorageState] document is undefined.");
          }
      }, [customEventTypeName]);
      var set = react.useCallback(function (newValue) {
          isUpdateFromCrossDocumentListener.current = false;
          isUpdateFromWithinDocumentListener.current = false;
          setValue(newValue);
          broadcastValueWithinDocument(newValue);
      }, [broadcastValueWithinDocument]);
      var remove = react.useCallback(function () {
          sessionStorage.removeItem(key);
      }, [key]);
      return [value, set, remove];
  }

  function useStackState(initialList) {
      var _a = react.useState(__spreadArray([], initialList, true)), list = _a[0], setList = _a[1];
      var length = list.length;
      var listInReverse = react.useMemo(function () {
          var reverseList = __spreadArray([], list, true);
          reverseList.reverse();
          return reverseList;
      }, [list]);
      var push = react.useCallback(function (item) {
          var newList = __spreadArray(__spreadArray([], list, true), [item], false);
          setList(newList);
          return newList.length;
      }, [list]);
      var pop = react.useCallback(function () {
          if (list.length > 0) {
              var lastItem = list[list.length - 1];
              setList(__spreadArray([], list.slice(0, list.length - 1), true));
              return lastItem;
          }
          return undefined;
      }, [list]);
      var peek = react.useCallback(function () {
          if (list.length > 0) {
              return list[list.length - 1];
          }
          return undefined;
      }, [list]);
      var clear = function () { return setList([]); };
      var isEmpty = react.useCallback(function () { return list.length === 0; }, [list]);
      var controls = {
          clear: clear,
          isEmpty: isEmpty,
          length: length,
          peek: peek,
          pop: pop,
          push: push,
      };
      return [list, controls, listInReverse];
  }

  /**
   * useThrottle
   * Throttles a function with a timeout and ensures
   * that the callback function runs at most once in that duration
   *
   * @param callback The callback to throttle
   * @param timeout Throttle timeout
   * @see {@link https://react-hooks.org/docs/useThrottle}
   */
  function useThrottle(callback, timeout) {
      if (timeout === void 0) { timeout = 300; }
      var _a = react.useState(true), ready = _a[0], setReady = _a[1];
      var timerRef = react.useRef(undefined);
      var throttledFunction = react.useCallback(function () {
          var args = [];
          for (var _i = 0; _i < arguments.length; _i++) {
              args[_i] = arguments[_i];
          }
          if (!ready) {
              return;
          }
          setReady(false);
          callback.apply(void 0, args);
      }, [ready, callback]);
      react.useEffect(function () {
          if (!ready) {
              timerRef.current = window.setTimeout(function () {
                  setReady(true);
              }, timeout);
              return function () { return window.clearTimeout(timerRef.current); };
          }
          return noop;
      }, [ready, timeout]);
      return [throttledFunction, ready];
  }

  /**
   * A setTimeout hook that calls a callback after a timeout duration
   *
   * @param cb The callback to be invoked after timeout
   * @param timeoutDelayMs Amount of time in ms after which to invoke
   */
  function useTimeout(callback_, timeoutDelayMs) {
      if (timeoutDelayMs === void 0) { timeoutDelayMs = 0; }
      useWarningOnMountInDevelopment("useTimeout is deprecated, it will be removed in rooks v7. Please use useTimeoutWhen instead.");
      var _a = react.useState(false), isTimeoutActive = _a[0], setIsTimeoutActive = _a[1];
      var savedRefCallback = react.useRef();
      react.useEffect(function () {
          savedRefCallback.current = callback_;
      }, [callback_]);
      function callback() {
          savedRefCallback.current && savedRefCallback.current();
          clear();
      }
      var clear = react.useCallback(function () {
          setIsTimeoutActive(false);
      }, []);
      var start = react.useCallback(function () {
          setIsTimeoutActive(true);
      }, []);
      react.useEffect(function () {
          if (isTimeoutActive) {
              if (typeof window !== "undefined") {
                  var timeout_1 = window.setTimeout(callback, timeoutDelayMs);
                  return function () {
                      window.clearTimeout(timeout_1);
                  };
              }
              else {
                  console.warn("useTimeout: window is undefined.");
              }
          }
          return noop;
      }, [isTimeoutActive, timeoutDelayMs]);
      return {
          clear: clear,
          isActive: isTimeoutActive,
          start: start,
          stop: clear,
      };
  }

  /**
   * A setTimeout hook that calls a callback after a timeout duration
   * when a condition is true
   *
   * @param cb The callback to be invoked after timeout
   * @param timeoutDelayMs Amount of time in ms after which to invoke
   * @param when The condition which when true, sets the timeout
   */
  function useTimeoutWhen(callback_, timeoutDelayMs, when) {
      if (timeoutDelayMs === void 0) { timeoutDelayMs = 0; }
      if (when === void 0) { when = true; }
      var savedRefCallback = react.useRef();
      react.useEffect(function () {
          savedRefCallback.current = callback_;
      });
      function callback() {
          savedRefCallback.current && savedRefCallback.current();
      }
      react.useEffect(function () {
          if (when) {
              if (typeof window !== "undefined") {
                  var timeout_1 = window.setTimeout(callback, timeoutDelayMs);
                  return function () {
                      window.clearTimeout(timeout_1);
                  };
              }
              else {
                  console.warn("useTimeoutWhen: window is undefined.");
              }
          }
          return noop;
      }, [when]);
  }

  var defaultToggleFunction = function (value) { return !value; };
  /**
   * Use toggle hook helps you easily toggle a value
   *
   * @param initialValue Initial value of the toggle, which will be false if not provided.
   * @param toggleFunction A toggle function. This allows for non boolean toggles
   * @example
   * const [value, toggle] = useToggle("on", _value => _value === "on" ? "off" : "on");
   * // value is "on"
   * // toggle() will change value to "off". Calling it again will change value to "on".
   */
  function useToggle(initialValue, toggleFunction) {
      if (initialValue === void 0) { initialValue = false; }
      if (toggleFunction === void 0) { toggleFunction = defaultToggleFunction; }
      return react.useReducer(toggleFunction, initialValue);
  }

  var defaultOptions$4 = { maxSize: 100 };
  /**
   * useUndoState hook
   * Drop in replacement for useState hook but with undo functionality.
   *
   * @typedef UndoStateOptions
   * @type {object}
   * @property {number} maxSize - Maximum number of states to keep in the undo stack.
   * @param {any} defaultValue - Default value to use for the state. This will be the first value in the undo stack.
   * @param {UseUndoStateOptions} options - Options for the undo state. Currently takes the maxSize option.
   * @returns {UseUndoStateReturnValue}
   * @see {@link https://react-hooks.org/docs/useUndoState}
   */
  var useUndoState = function (defaultValue, options) {
      var maxSize = react.useMemo(function () {
          return __assign(__assign({}, defaultOptions$4), options);
      }, [options]).maxSize;
      var _a = react.useState([defaultValue]), value = _a[0], setValue = _a[1];
      var push = react.useCallback(function (argument) {
          return setValue(function (current) {
              var restValues = current.length >= maxSize ? current.slice(0, maxSize) : current;
              if (typeof argument === "function") {
                  // I dislike this type assertion, but it's the only way to get the type to match
                  // as the type guard doesn't seem to be working here.
                  return __spreadArray([argument(current[0])], restValues, true);
              }
              else {
                  return __spreadArray([argument], restValues, true);
              }
          });
      }, [maxSize]);
      var undo = react.useCallback(function () {
          setValue(function (current) {
              if (current.length === 1) {
                  return current;
              }
              var values = current.slice(1);
              return values;
          });
      }, []);
      return [value[0], push, undo];
  };

  // eslint-disable-next-line @typescript-eslint/prefer-ts-expect-error
  function normalizeRect(rect) {
      if (rect.width === undefined) {
          rect.width = rect.right - rect.left;
      }
      if (rect.height === undefined) {
          rect.height = rect.bottom - rect.top;
      }
      return rect;
  }
  var initialState = { isVisible: null, visibilityRect: {} };
  function reducer(state, action) {
      switch (action.type) {
          case "set":
              if (state.isVisible === action.payload.isVisible) {
                  return state;
              }
              return action.payload;
          default:
              return state;
      }
  }
  var DEFAULT_OPTIONS = {
      containment: null,
      intervalCheck: false,
      minTopValue: 0,
      partialVisibility: false,
      resizeCheck: false,
      resizeDebounce: 250,
      resizeThrottle: -1,
      scrollCheck: true,
      scrollDebounce: 250,
      scrollThrottle: -1,
      shouldCheckOnMount: true,
  };
  /**
   * useVisibilitySensor hook
   * Tracks the visibility of a ref
   *
   * @param ref The ref to track visibility of
   * @param opts Options
   * @see {@link https://react-hooks.org/docs/useVisibilitySensor}
   */
  function useVisibilitySensor(ref, options) {
      useWarningOnMountInDevelopment("useVisibilitySensor is deprecated, it will be removed in rooks v7. Please use useInViewRef instead.");
      /*
          Create local state
        */
      var _a = react.useReducer(reducer, initialState), localState = _a[0], dispatch = _a[1];
      /*
          Get options
        */
      var _b = Object.assign({}, DEFAULT_OPTIONS, options), containment = _b.containment, intervalCheck = _b.intervalCheck, scrollCheck = _b.scrollCheck, shouldCheckOnMount = _b.shouldCheckOnMount, scrollDebounce = _b.scrollDebounce, scrollThrottle = _b.scrollThrottle, resizeCheck = _b.resizeCheck, resizeDebounce = _b.resizeDebounce, resizeThrottle = _b.resizeThrottle, partialVisibility = _b.partialVisibility, minTopValue = _b.minTopValue;
      function getContainer() {
          return containment || window;
      }
      /*
          Check visibility
        */
      function checkVisibility() {
          var containmentRect;
          if (containment) {
              var containmentDOMRect = containment.getBoundingClientRect();
              containmentRect = {
                  bottom: containmentDOMRect.bottom,
                  left: containmentDOMRect.left,
                  right: containmentDOMRect.right,
                  top: containmentDOMRect.top,
              };
          }
          else {
              containmentRect = {
                  bottom: window.innerHeight || document.documentElement.clientHeight,
                  left: 0,
                  right: window.innerWidth || document.documentElement.clientWidth,
                  top: 0,
              };
          }
          var rect = normalizeRect(ref.current.getBoundingClientRect());
          var hasSize = rect.height > 0 && rect.width > 0;
          var visibilityRect = {
              bottom: rect.bottom <= containmentRect.bottom,
              left: rect.left >= containmentRect.left,
              right: rect.right <= containmentRect.right,
              top: rect.top >= containmentRect.top,
          };
          var isVisible = hasSize &&
              visibilityRect.top &&
              visibilityRect.left &&
              visibilityRect.bottom &&
              visibilityRect.right;
          // check for partial visibility
          if (hasSize && partialVisibility) {
              var partialVisible = rect.top <= containmentRect.bottom &&
                  rect.bottom >= containmentRect.top &&
                  rect.left <= containmentRect.right &&
                  rect.right >= containmentRect.left;
              // account for partial visibility on a single edge
              if (typeof partialVisibility === "string") {
                  partialVisible = visibilityRect[partialVisibility];
              }
              // if we have minimum top visibility set by props, lets check, if it meets the passed value
              // so if for instance element is at least 200px in viewport, then show it.
              isVisible = minTopValue
                  ? partialVisible && rect.top <= containmentRect.bottom - minTopValue
                  : partialVisible;
          }
          return { isVisible: isVisible, visibilityRect: visibilityRect };
      }
      function updateIsVisible() {
          if (!ref.current) {
              return;
          }
          var _a = checkVisibility(), isVisible = _a.isVisible, visibilityRect = _a.visibilityRect;
          dispatch({
              payload: { isVisible: isVisible, visibilityRect: visibilityRect },
              type: "set",
          });
      }
      // run only once, hence empty array as second argument
      react.useEffect(function () {
          if (shouldCheckOnMount) {
              updateIsVisible();
          }
      }, []);
      react.useEffect(function () {
          updateIsVisible();
      }, [ref.current]);
      // If interval check is needed
      react.useEffect(function () {
          if (intervalCheck && intervalCheck > 0) {
              var intervalTimer_1 = setInterval(function () {
                  updateIsVisible();
              }, intervalCheck);
              return function () {
                  clearInterval(intervalTimer_1);
              };
          }
          return noop;
      }, [intervalCheck]);
      function createListener(event, debounce, throttle) {
          var container = getContainer();
          var timeout;
          var listener;
          var later = function () {
              timeout = null;
              updateIsVisible();
          };
          if (throttle > -1) {
              listener = function () {
                  if (!timeout) {
                      timeout = setTimeout(later, throttle || 0);
                  }
              };
          }
          else {
              listener = function () {
                  clearTimeout(timeout);
                  timeout = setTimeout(later, debounce || 0);
              };
          }
          container.addEventListener(event, listener);
          return function () {
              clearTimeout(timeout);
              container.removeEventListener(event, listener);
          };
      }
      // If scroll check is needed
      useIsomorphicEffect(function () {
          if (scrollCheck) {
              return createListener("scroll", scrollDebounce, scrollThrottle);
          }
          return noop;
      }, []);
      // if resize check is needed
      useIsomorphicEffect(function () {
          if (resizeCheck) {
              return createListener("resize", resizeDebounce, resizeThrottle);
          }
          return noop;
      }, []);
      return localState;
  }

  function computeScrollPosition() {
      if (typeof window === "undefined") {
          return {
              scrollX: 0,
              scrollY: 0,
          };
      }
      else {
          return {
              scrollX: window.scrollX || window.pageXOffset,
              scrollY: window.scrollY || window.pageYOffset,
          };
      }
  }
  /**
   *
   * useWindowScrollPosition hook
   * A React hook to get the scroll position of the window
   *
   * @returns an object containing scrollX and scrollY values
   */
  function useWindowScrollPosition() {
      var _a = react.useState(computeScrollPosition), scrollPosition = _a[0], setScrollPosition = _a[1];
      /**
       * Recalculate on scroll
       */
      useOnWindowScroll(function () {
          setScrollPosition(computeScrollPosition());
      }, true, true);
      /**
       * Recalculate on resize
       */
      useOnWindowResize(function () {
          setScrollPosition(computeScrollPosition());
      }, true, true);
      return scrollPosition;
  }

  var nullDimensions = {
      innerHeight: null,
      innerWidth: null,
      outerHeight: null,
      outerWidth: null,
  };
  function getDimensions() {
      return {
          innerHeight: window.innerHeight,
          innerWidth: window.innerWidth,
          outerHeight: window.outerHeight,
          outerWidth: window.outerWidth,
      };
  }
  /**
   * useWindowSize hook
   * A hook that provides information of the dimensions of the window
   *
   * @returns Dimensions of the window
   */
  function useWindowSize() {
      var _a = react.useState(function () {
          if (typeof window === "undefined") {
              return nullDimensions;
          }
          else {
              return getDimensions();
          }
      }), windowSize = _a[0], setWindowSize = _a[1];
      function onResize() {
          setWindowSize(getDimensions());
      }
      // set resize handler once on mount and clean before unmount
      useIsomorphicEffect(function () {
          if (typeof window === "undefined") {
              return function () { };
          }
          else {
              window.addEventListener("resize", onResize);
              return function () {
                  window.removeEventListener("resize", onResize);
              };
          }
      }, []);
      return windowSize;
  }

  exports.useBoundingclientrect = useBoundingclientrect;
  exports.useBoundingclientrectRef = useBoundingclientrectRef;
  exports.useCountdown = useCountdown;
  exports.useCounter = useCounter;
  exports.useDebounce = useDebounce;
  exports.useDebouncedValue = useDebouncedValue;
  exports.useDidMount = useDidMount;
  exports.useDidUpdate = useDidUpdate;
  exports.useDimensionsRef = useDimensionsRef;
  exports.useDocumentEventListener = useDocumentEventListener;
  exports.useEffectOnceWhen = useEffectOnceWhen;
  exports.useEventListenerRef = useEventListenerRef;
  exports.useForkRef = useForkRef;
  exports.useFreshRef = useFreshRef;
  exports.useFreshTick = useFreshTick;
  exports.useFullscreen = useFullscreen;
  exports.useGeolocation = useGeolocation;
  exports.useGetIsMounted = useGetIsMounted;
  exports.useInViewRef = useInViewRef;
  exports.useInput = useInput;
  exports.useIntersectionObserverRef = useIntersectionObserverRef;
  exports.useInterval = useInterval;
  exports.useIntervalWhen = useIntervalWhen;
  exports.useIsomorphicEffect = useIsomorphicEffect;
  exports.useKey = useKey;
  exports.useKeyBindings = useKeyBindings;
  exports.useKeyRef = useKeyRef;
  exports.useKeys = useKeys;
  exports.useLifecycleLogger = useLifecycleLogger;
  exports.useLocalstorage = useLocalstorage;
  exports.useLocalstorageState = useLocalstorageState;
  exports.useMapState = useMapState;
  exports.useMediaMatch = useMediaMatch;
  exports.useMergeRefs = useMergeReferences;
  exports.useMouse = useMouse;
  exports.useMultiSelectableList = useMultiSelectableList;
  exports.useMutationObserver = useMutationObserver;
  exports.useMutationObserverRef = useMutationObserverRef;
  exports.useNavigatorLanguage = useNavigatorLanguage;
  exports.useOnWindowResize = useOnWindowResize;
  exports.useOnWindowScroll = useOnWindowScroll;
  exports.useOnline = useOnline;
  exports.useOutsideClick = useOutsideClick;
  exports.useOutsideClickRef = useOutsideClickRef;
  exports.usePrevious = usePrevious;
  exports.usePreviousDifferent = usePreviousDifferent;
  exports.usePreviousImmediate = usePreviousImmediate;
  exports.useQueueState = useQueueState;
  exports.useRaf = useRaf;
  exports.useRefElement = useRefElement;
  exports.useSelect = useSelect;
  exports.useSelectableList = useSelectableList;
  exports.useSessionstorage = useSessionstorage;
  exports.useSessionstorageState = useSessionstorageState;
  exports.useStackState = useStackState;
  exports.useThrottle = useThrottle;
  exports.useTimeout = useTimeout;
  exports.useTimeoutWhen = useTimeoutWhen;
  exports.useToggle = useToggle;
  exports.useUndoState = useUndoState;
  exports.useUpdateEffect = useUpdateEffect;
  exports.useVisibilitySensor = useVisibilitySensor;
  exports.useWillUnmount = useWillUnmount;
  exports.useWindowEventListener = useWindowEventListener;
  exports.useWindowScrollPosition = useWindowScrollPosition;
  exports.useWindowSize = useWindowSize;

  Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=rooks.js.map
