import { useState } from "react";
import { useOnWindowResize } from "./useOnWindowResize";
import { useOnWindowScroll } from "./useOnWindowScroll";
function computeScrollPosition() {
    if (typeof window === "undefined") {
        return {
            scrollX: 0,
            scrollY: 0,
        };
    }
    else {
        return {
            scrollX: window.scrollX || window.pageXOffset,
            scrollY: window.scrollY || window.pageYOffset,
        };
    }
}
/**
 *
 * useWindowScrollPosition hook
 * A React hook to get the scroll position of the window
 *
 * @returns an object containing scrollX and scrollY values
 */
function useWindowScrollPosition() {
    var _a = useState(computeScrollPosition), scrollPosition = _a[0], setScrollPosition = _a[1];
    /**
     * Recalculate on scroll
     */
    useOnWindowScroll(function () {
        setScrollPosition(computeScrollPosition());
    }, true, true);
    /**
     * Recalculate on resize
     */
    useOnWindowResize(function () {
        setScrollPosition(computeScrollPosition());
    }, true, true);
    return scrollPosition;
}
export { useWindowScrollPosition };
