import type { UseUndoStateOptions, UseUndoStateReturnValue } from "../types/types";
import type { ExcludeFunction } from "../types/utils";
/**
 * useUndoState hook
 * Drop in replacement for useState hook but with undo functionality.
 *
 * @typedef UndoStateOptions
 * @type {object}
 * @property {number} maxSize - Maximum number of states to keep in the undo stack.
 * @param {any} defaultValue - Default value to use for the state. This will be the first value in the undo stack.
 * @param {UseUndoStateOptions} options - Options for the undo state. Currently takes the maxSize option.
 * @returns {UseUndoStateReturnValue}
 * @see {@link https://react-hooks.org/docs/useUndoState}
 */
declare const useUndoState: <T>(defaultValue: Exclude<T, Function>, options?: UseUndoStateOptions | undefined) => UseUndoStateReturnValue<T>;
export { useUndoState };
