import { useReducer } from "react";
var defaultToggleFunction = function (value) { return !value; };
/**
 * Use toggle hook helps you easily toggle a value
 *
 * @param initialValue Initial value of the toggle, which will be false if not provided.
 * @param toggleFunction A toggle function. This allows for non boolean toggles
 * @example
 * const [value, toggle] = useToggle("on", _value => _value === "on" ? "off" : "on");
 * // value is "on"
 * // toggle() will change value to "off". Calling it again will change value to "on".
 */
export function useToggle(initialValue, toggleFunction) {
    if (initialValue === void 0) { initialValue = false; }
    if (toggleFunction === void 0) { toggleFunction = defaultToggleFunction; }
    return useReducer(toggleFunction, initialValue);
}
