import { noop } from "../utils/noop";
import { useState, useRef, useEffect, useCallback } from "react";
import { useWarningOnMountInDevelopment } from "./useWarningOnMountInDevelopment";
/**
 * A setTimeout hook that calls a callback after a timeout duration
 *
 * @param cb The callback to be invoked after timeout
 * @param timeoutDelayMs Amount of time in ms after which to invoke
 */
function useTimeout(callback_, timeoutDelayMs) {
    if (timeoutDelayMs === void 0) { timeoutDelayMs = 0; }
    useWarningOnMountInDevelopment("useTimeout is deprecated, it will be removed in rooks v7. Please use useTimeoutWhen instead.");
    var _a = useState(false), isTimeoutActive = _a[0], setIsTimeoutActive = _a[1];
    var savedRefCallback = useRef();
    useEffect(function () {
        savedRefCallback.current = callback_;
    }, [callback_]);
    function callback() {
        savedRefCallback.current && savedRefCallback.current();
        clear();
    }
    var clear = useCallback(function () {
        setIsTimeoutActive(false);
    }, []);
    var start = useCallback(function () {
        setIsTimeoutActive(true);
    }, []);
    useEffect(function () {
        if (isTimeoutActive) {
            if (typeof window !== "undefined") {
                var timeout_1 = window.setTimeout(callback, timeoutDelayMs);
                return function () {
                    window.clearTimeout(timeout_1);
                };
            }
            else {
                console.warn("useTimeout: window is undefined.");
            }
        }
        return noop;
    }, [isTimeoutActive, timeoutDelayMs]);
    return {
        clear: clear,
        isActive: isTimeoutActive,
        start: start,
        stop: clear,
    };
}
export { useTimeout };
