declare type Callback<T> = (...args: T[]) => void;
/**
 * useThrottle
 * Throttles a function with a timeout and ensures
 * that the callback function runs at most once in that duration
 *
 * @param callback The callback to throttle
 * @param timeout Throttle timeout
 * @see {@link https://react-hooks.org/docs/useThrottle}
 */
declare function useThrottle<T>(callback: Callback<T>, timeout?: number): [Callback<T>, boolean];
export { useThrottle };
