import type { OptionalIndexValue } from "../types/index-value";
declare type Selection<T> = [number, T];
declare type UseSelectableListReturnType<T> = [
    Selection<T>,
    {
        matchSelection: (parameters: OptionalIndexValue<T>) => boolean;
        toggleSelection: (parameters: OptionalIndexValue<T>) => () => void;
        updateSelection: (parameters: OptionalIndexValue<T>) => () => void;
    }
];
/**
 * useSelectableList
 * Easily select a single value from a list of values. very useful for radio buttons, select inputs  etc.
 *
 * @param list - The list of values to select from
 * @param initialIndex  - The index of the initial selection
 * @param allowUnselected
 * @see {@link https://react-hooks.org/docs/useSelectableList}
 */
declare function useSelectableList<T>(list?: T[], initialIndex?: number, allowUnselected?: boolean): UseSelectableListReturnType<T>;
export { useSelectableList };
