import { useCallback, useState } from "react";
/**
 * useRefElement hook for React
 * Helps bridge gap between callback ref and state
 * Manages the element called with callback ref api using state variable
 */
function useRefElement() {
    var _a = useState(null), refElement = _a[0], setRefElement = _a[1];
    var ref = useCallback(function (refElement) {
        setRefElement(refElement);
    }, []);
    return [ref, refElement];
}
export { useRefElement };
