import { useRef, useEffect } from "react";
import { useWarningOnMountInDevelopment } from "./useWarningOnMountInDevelopment";
/**
 * usePrevious hook for React
 *
 * @param currentValue The value whose previous value is to be tracked
 * @returns The previous value
 */
function usePrevious(currentValue) {
    useWarningOnMountInDevelopment("usePrevious is deprecated, it will be removed in rooks v7. Please use usePreviousImmediate instead.");
    var previousRef = useRef(null);
    useEffect(function () {
        previousRef.current = currentValue;
    }, [currentValue]);
    return previousRef.current;
}
export { usePrevious };
