import { useState } from "react";
import { useWindowEventListener } from "./useWindowEventListener";
function getLanguage() {
    // eslint-disable-next-line no-negated-condition
    if (typeof navigator !== "undefined") {
        // @ts-expect-error - This is a valid type for the navigator object in IE
        // eslint-disable-next-line @typescript-eslint/dot-notation
        return navigator.language || navigator["userLanguage"];
    }
    else {
        return null;
    }
}
/**
 * useNavigatorLanguage hook
 * Returns the language of the navigator
 *
 * @returns {Language}
 * @see {@link https://react-hooks.org/docs/useNavigatorLanguage}
 */
export function useNavigatorLanguage() {
    var _a = useState(getLanguage), language = _a[0], setLanguage = _a[1];
    useWindowEventListener("languagechange", function () {
        setLanguage(getLanguage);
    });
    return language;
}
