import { useEffect, useState } from "react";
var initialMouseState = {
    clientX: null,
    clientY: null,
    movementX: null,
    movementY: null,
    offsetX: null,
    offsetY: null,
    pageX: null,
    pageY: null,
    screenX: null,
    screenY: null,
    x: null,
    y: null,
};
function getMousePositionFromEvent(e) {
    var screenX = e.screenX, screenY = e.screenY, movementX = e.movementX, movementY = e.movementY, pageX = e.pageX, pageY = e.pageY, clientX = e.clientX, clientY = e.clientY, offsetX = e.offsetX, offsetY = e.offsetY;
    return {
        clientX: clientX,
        clientY: clientY,
        movementX: movementX,
        movementY: movementY,
        offsetX: offsetX,
        offsetY: offsetY,
        pageX: pageX,
        pageY: pageY,
        screenX: screenX,
        screenY: screenY,
        x: screenX,
        y: screenY,
    };
}
/**
 * useMouse hook
 *
 * Retrieves current mouse position and information about the position like
 * screenX, pageX, clientX, movementX, offsetX
 */
export function useMouse() {
    var _a = useState(initialMouseState), mousePosition = _a[0], setMousePostition = _a[1];
    function updateMousePosition(e) {
        setMousePostition(getMousePositionFromEvent(e));
    }
    useEffect(function () {
        document.addEventListener("mousemove", updateMousePosition);
        return function () {
            document.removeEventListener("mousemove", updateMousePosition);
        };
    }, []);
    return mousePosition;
}
