var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { useCallback, useState } from "react";
/**
 * useMapState hook
 * A hook to manage state in the form of a map or object.
 *
 * @param initialValue Initial value of the map
 */
function useMapState(initialValue) {
    var _a = useState(initialValue), map = _a[0], setMap = _a[1];
    var set = useCallback(function (key, value) {
        setMap(function (currentMap) {
            var _a;
            return (__assign(__assign({}, currentMap), (_a = {}, _a[key] = value, _a)));
        });
    }, []);
    var has = useCallback(function (key) {
        return typeof map[key] !== "undefined";
    }, [map]);
    var setMultiple = useCallback(function (nextMap) {
        setMap(function (currentMap) { return (__assign(__assign({}, currentMap), nextMap)); });
    }, []);
    var removeMultiple = useCallback(function () {
        var keys = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            keys[_i] = arguments[_i];
        }
        setMap(function (currentMap) {
            var nextMap = __assign({}, currentMap);
            for (var _i = 0, keys_1 = keys; _i < keys_1.length; _i++) {
                var key = keys_1[_i];
                delete nextMap[key];
            }
            return nextMap;
        });
    }, [setMap]);
    var remove = useCallback(function (key) {
        setMap(function (currentMap) {
            var nextMap = __assign({}, currentMap);
            delete nextMap[key];
            return nextMap;
        });
    }, [setMap]);
    var removeAll = useCallback(function () {
        setMap(function (currentMap) {
            var nextMap = __assign({}, currentMap);
            for (var key in nextMap) {
                delete nextMap[key];
            }
            return nextMap;
        });
    }, [setMap]);
    return [
        map,
        {
            has: has,
            remove: remove,
            removeAll: removeAll,
            removeMultiple: removeMultiple,
            set: set,
            setMultiple: setMultiple,
        },
    ];
}
export { useMapState };
