import type { Dispatch, SetStateAction } from "react";
declare type UseLocalstorageStateReturnValue<S> = [
    S,
    Dispatch<SetStateAction<S>>,
    () => void
];
/**
 * useLocalstorageState hook
 * Tracks a value within localStorage and updates it
 *
 * @param {string} key - Key of the localStorage object
 * @param {any} initialState - Default initial value
 */
declare function useLocalstorageState<S>(key: string, initialState?: S | (() => S)): UseLocalstorageStateReturnValue<S>;
export { useLocalstorageState };
