/* eslint-disable sort-keys-fix/sort-keys-fix */
/* eslint-disable @typescript-eslint/no-explicit-any */
import { noop } from "../utils/noop";
import { useState, useEffect, useCallback } from "react";
import { useWarningOnMountInDevelopment } from "./useWarningOnMountInDevelopment";
/**
 * useLocalstorage hook
 * Tracks a value within localStorage and updates it
 *
 * @param {string} key - Key of the localStorage object
 * @param {any} defaultValue - Default initial value
 */
function useLocalstorage(key, defaultValue) {
    if (defaultValue === void 0) { defaultValue = null; }
    var _a = useState(getValueFromLocalStorage()), value = _a[0], setValue = _a[1];
    useWarningOnMountInDevelopment("useLocalstorage is deprecated, it will be removed in the next major release. Please use useLocalstorageState instead.");
    function init() {
        var valueLoadedFromLocalStorage = getValueFromLocalStorage();
        if (valueLoadedFromLocalStorage === null ||
            valueLoadedFromLocalStorage === "null") {
            set(defaultValue);
        }
    }
    function getValueFromLocalStorage() {
        if (typeof localStorage === "undefined") {
            return null;
        }
        var storedValue = localStorage.getItem(key) || "null";
        try {
            return JSON.parse(storedValue);
        }
        catch (error) {
            console.error(error);
        }
        return storedValue;
    }
    function saveValueToLocalStorage(valueToSet) {
        if (typeof localStorage === "undefined") {
            return null;
        }
        return localStorage.setItem(key, JSON.stringify(valueToSet));
    }
    var set = useCallback(function (newValue) {
        setValue(newValue);
        saveValueToLocalStorage(newValue);
    }, []);
    var listen = useCallback(function (event) {
        if (event.storageArea === localStorage && event.key === key) {
            setValue(event.newValue);
        }
    }, []);
    // eslint-disable-next-line consistent-return
    var remove = useCallback(function () {
        set(null);
        if (typeof localStorage === "undefined") {
            return false;
        }
        localStorage.removeItem(key);
        return undefined;
    }, [key]);
    // initialize
    useEffect(function () {
        init();
    }, []);
    // check for changes across windows
    useEffect(function () {
        if (typeof window !== "undefined") {
            window.addEventListener("storage", listen);
            return function () {
                window.removeEventListener("storage", listen);
            };
        }
        else {
            console.warn("useLocalstorage: window is undefined.");
        }
        return noop;
    }, []);
    var handler = Object.assign([value, set, remove], {
        value: value,
        remove: remove,
        set: set,
    });
    return handler;
}
export { useLocalstorage };
