var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { useEffect, useState, useCallback, useRef, useMemo } from "react";
import { doesIdentifierMatchKeyboardEvent } from "../utils/doesIdentifierMatchKeyboardEvent";
import { noop } from "../utils/noop";
var defaultOptions = {
    eventTypes: ["keydown"],
    when: true,
};
/**
 * useKeyRef hook
 *
 * Fires a callback on keyboard events like keyDown, keyPress and keyUp
 *
 * @param {[string|number]} keys List of keys to listen for. Eg: ["a", "b"]
 * @param {Function} callback Callback to fire on keyboard events
 * @param {Options} options Options
 * @returns {CallbackRef} CallbackRef
 * @see {@link https://react-hooks.org/docs/useKeyRef}
 */
function useKeyRef(keys, callback, options) {
    var _a = useState(null), targetNode = _a[0], setTargetNode = _a[1];
    var ref = useCallback(function (node) {
        setTargetNode(node);
    }, []);
    var keyList = useMemo(function () {
        if (Array.isArray(keys)) {
            return keys;
        }
        else {
            return [keys];
        }
    }, [keys]);
    var internalOptions = useMemo(function () {
        return __assign(__assign({}, defaultOptions), options);
    }, [options]);
    var when = internalOptions.when, eventTypes = internalOptions.eventTypes;
    var callbackRef = useRef(callback);
    useEffect(function () {
        callbackRef.current = callback;
    });
    var handle = useCallback(function (event) {
        if (keyList.some(function (identifier) {
            return doesIdentifierMatchKeyboardEvent(event, identifier);
        })) {
            callbackRef.current(event);
        }
    }, [keyList]);
    useEffect(function () {
        if (when && targetNode) {
            for (var _i = 0, eventTypes_1 = eventTypes; _i < eventTypes_1.length; _i++) {
                var eventType = eventTypes_1[_i];
                // eslint-disable-next-line prefer-arrow-callback
                targetNode.addEventListener(eventType, handle);
            }
            return function () {
                for (var _i = 0, eventTypes_2 = eventTypes; _i < eventTypes_2.length; _i++) {
                    var eventType = eventTypes_2[_i];
                    targetNode.removeEventListener(eventType, handle);
                }
            };
        }
        return noop;
    }, [targetNode, when, eventTypes, keyList, handle]);
    return ref;
}
export { useKeyRef };
