import type { CallbackRef } from "../utils/utils";
declare type TrackedKeyEvents = "keydown" | "keypress" | "keyup";
declare type Callback = (event: KeyboardEvent) => void;
declare type Options = {
    /**
     * Keyboardevent types to listen for. Valid options are keyDown, keyPress and keyUp
     */
    eventTypes?: TrackedKeyEvents[];
    /**
     * Condition which if true, will enable the event listeners
     */
    when?: boolean;
};
/**
 * useKeyRef hook
 *
 * Fires a callback on keyboard events like keyDown, keyPress and keyUp
 *
 * @param {[string|number]} keys List of keys to listen for. Eg: ["a", "b"]
 * @param {Function} callback Callback to fire on keyboard events
 * @param {Options} options Options
 * @returns {CallbackRef} CallbackRef
 * @see {@link https://react-hooks.org/docs/useKeyRef}
 */
declare function useKeyRef(keys: Array<number | string> | number | string, callback: Callback, options?: Options): CallbackRef;
export { useKeyRef };
