import { useKey } from "./useKey";
/**
 * useKeyBindings
 *
 * useKeyBindings binds pairs of keyboard events and handlers
 *
 * @param { KeyBindings } keyBindings
 * @param {Options} options
 * @see {@link https://react-hooks.org/docs/useKeyBindings}
 */
var useKeyBindings = function (keyBindings, options) {
    for (var key in keyBindings) {
        // eslint-disable-next-line react-hooks/rules-of-hooks
        useKey(key, keyBindings[key], options);
    }
};
export { useKeyBindings };
