var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { useEffect, useCallback, useRef, useMemo } from "react";
import { doesIdentifierMatchKeyboardEvent } from "../utils/doesIdentifierMatchKeyboardEvent";
import { noop } from "../utils/noop";
var defaultOptions = {
    eventTypes: ["keydown"],
    when: true,
};
/**
 * useKey hook
 *
 * Fires a callback on keyboard events like keyDown, keyPress and keyUp
 *
 * @param {TrackedKeyEvents} keys List of keys to listen for. Eg: ["a", "b"]
 * @param {Callback} callback  Callback to fire on keyboard events
 * @param {Options} options Options
 * @see {@link https://react-hooks.org/docs/useKey}
 */
function useKey(keys, callback, options) {
    var keyList = useMemo(function () {
        if (Array.isArray(keys)) {
            return keys;
        }
        else {
            return [keys];
        }
    }, [keys]);
    var internalOptions = useMemo(function () {
        return __assign(__assign({}, defaultOptions), options);
    }, [options]);
    var when = internalOptions.when, eventTypes = internalOptions.eventTypes;
    var callbackRef = useRef(callback);
    var target = internalOptions.target;
    useEffect(function () {
        callbackRef.current = callback;
    });
    var handle = useCallback(function (event) {
        if (keyList.some(function (identifier) {
            return doesIdentifierMatchKeyboardEvent(event, identifier);
        })) {
            callbackRef.current(event);
        }
    }, [keyList]);
    useEffect(function () {
        if (when && typeof window !== "undefined") {
            // If target is defined by the user
            if (target) {
                var targetNode_1 = target.current;
                if (targetNode_1) {
                    for (var _i = 0, eventTypes_1 = eventTypes; _i < eventTypes_1.length; _i++) {
                        var eventType = eventTypes_1[_i];
                        targetNode_1.addEventListener(eventType, handle);
                    }
                    return function () {
                        for (var _i = 0, eventTypes_3 = eventTypes; _i < eventTypes_3.length; _i++) {
                            var eventType = eventTypes_3[_i];
                            targetNode_1.removeEventListener(eventType, handle);
                        }
                    };
                }
            }
            else {
                for (var _a = 0, eventTypes_2 = eventTypes; _a < eventTypes_2.length; _a++) {
                    var eventType = eventTypes_2[_a];
                    window.addEventListener(eventType, handle);
                }
                return function () {
                    for (var _i = 0, eventTypes_4 = eventTypes; _i < eventTypes_4.length; _i++) {
                        var eventType = eventTypes_4[_i];
                        window.removeEventListener(eventType, handle);
                    }
                };
            }
        }
        return noop;
    }, [when, eventTypes, keyList, target, callback, handle]);
}
export { useKey };
