import type { RefObject } from "react";
declare type TrackedKeyEvents = "keydown" | "keypress" | "keyup";
declare type Options = {
    /**
     * Keyboardevent types to listen for. Valid options are keyDown, keyPress and keyUp
     */
    eventTypes?: TrackedKeyEvents[];
    /**
     * target mutable ref on which the events should be listened. Doesn't work with callback refs.
     * Please use useKeyRef instead if you want to use with callback refs.
     * If no target is specified, events are listened to on the window. Defaults to window.
     */
    target?: RefObject<HTMLElement>;
    /**
     * Condition which if true, will enable the event listeners
     */
    when?: boolean;
};
/**
 * useKey hook
 *
 * Fires a callback on keyboard events like keyDown, keyPress and keyUp
 *
 * @param {TrackedKeyEvents} keys List of keys to listen for. Eg: ["a", "b"]
 * @param {Callback} callback  Callback to fire on keyboard events
 * @param {Options} options Options
 * @see {@link https://react-hooks.org/docs/useKey}
 */
declare function useKey(keys: Array<number | string> | number | string, callback: (event: KeyboardEvent) => void, options?: Options): void;
export { useKey };
