// See also: https://overreacted.io/making-setinterval-declarative-with-react-hooks/
import { useState, useEffect, useRef } from "react";
import { useWarningOnMountInDevelopment } from "./useWarningOnMountInDevelopment";
import { noop } from "../utils/noop";
/**
 *
 * useInterval hook
 *
 * Declaratively creates a setInterval to run a callback after a fixed
 * amount of time
 *
 *@param {Function} callback - Callback to be fired
 *@param {number} intervalId - Interval duration in milliseconds after which the callback is to be fired
 *@param {boolean} startImmediate - Whether the interval should start immediately on initialise
 *@returns {IntervalHandler}
 */
function useInterval(callback, intervalDuration, startImmediate) {
    if (startImmediate === void 0) { startImmediate = false; }
    useWarningOnMountInDevelopment("useInterval is deprecated, it will be removed in rooks v7. Please use useIntervalWhen instead.");
    var internalIdRef = useRef(null);
    var _a = useState(startImmediate), isRunning = _a[0], setIsRunning = _a[1];
    var savedCallback = useRef();
    function start() {
        if (!isRunning) {
            setIsRunning(true);
        }
    }
    function stop() {
        if (isRunning) {
            setIsRunning(false);
        }
    }
    // Remember the latest callback.
    useEffect(function () {
        savedCallback.current = callback;
    });
    // Set up the interval.
    useEffect(function () {
        function tick() {
            var _a;
            (_a = savedCallback.current) === null || _a === void 0 ? void 0 : _a.call(savedCallback);
        }
        if (intervalDuration !== null && isRunning) {
            var id_1 = setInterval(tick, intervalDuration);
            internalIdRef.current = id_1;
            return function () {
                internalIdRef.current = null;
                clearInterval(id_1);
            };
        }
        return noop;
    }, [intervalDuration, isRunning]);
    var handler;
    handler = [start, stop, internalIdRef.current];
    handler.start = start;
    handler.stop = stop;
    handler.intervalId = internalIdRef.current;
    return handler;
}
export { useInterval };
