import { useCallback, useEffect, useRef } from "react";
/**
 * @description useGetIsMounted hook checks if a component is mounted or not at the time.
 * Useful for async effects. Returns a callback that returns a boolean representing if the component
 * is mounted at the time.
 * @returns () => boolean
 * @see https://react-hooks.org/docs/useGetIsMounted
 */
export var useGetIsMounted = function () {
    var isMountedRef = useRef(false);
    var get = useCallback(function () { return isMountedRef.current; }, []);
    useEffect(function () {
        isMountedRef.current = true;
        return function () {
            isMountedRef.current = false;
        };
    }, []);
    return get;
};
