declare type UseGetIsMounted = () => () => boolean;
/**
 * @description useGetIsMounted hook checks if a component is mounted or not at the time.
 * Useful for async effects. Returns a callback that returns a boolean representing if the component
 * is mounted at the time.
 * @returns () => boolean
 * @see https://react-hooks.org/docs/useGetIsMounted
 */
export declare const useGetIsMounted: UseGetIsMounted;
export {};
