import { useState, useEffect, useCallback } from 'react';
import { useForkRef } from './useForkRef';
import { useMutationObserverRef } from './useMutationObserverRef';
/**
 * @param element HTML element whose boundingclientrect is needed
 * @returns ClientRect
 */
function getBoundingClientRect(element) {
    return element.getBoundingClientRect();
}
/**
 * useBoundingclientrectRef hook
 *
 * @returns [CallbackRef | null, ClientRect | DOMRect | null, () => void]
 */
function useBoundingclientrectRef() {
    var _a = useState(null), value = _a[0], setValue = _a[1];
    var _b = useState(null), node = _b[0], setNode = _b[1];
    var update = useCallback(function () {
        setValue(node ? getBoundingClientRect(node) : null);
    }, [node]);
    useEffect(function () {
        update();
    }, [node]);
    var ref = useCallback(function (node) {
        setNode(node);
    }, []);
    var mutationObserverRef = useMutationObserverRef(update)[0];
    var forkedRef = useForkRef(ref, mutationObserverRef);
    return [forkedRef, value, update];
}
export { useBoundingclientrectRef };
