"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useToggle = void 0;
var react_1 = require("react");
var defaultToggleFunction = function (value) { return !value; };
/**
 * Use toggle hook helps you easily toggle a value
 *
 * @param initialValue Initial value of the toggle, which will be false if not provided.
 * @param toggleFunction A toggle function. This allows for non boolean toggles
 * @example
 * const [value, toggle] = useToggle("on", _value => _value === "on" ? "off" : "on");
 * // value is "on"
 * // toggle() will change value to "off". Calling it again will change value to "on".
 */
function useToggle(initialValue, toggleFunction) {
    if (initialValue === void 0) { initialValue = false; }
    if (toggleFunction === void 0) { toggleFunction = defaultToggleFunction; }
    return (0, react_1.useReducer)(toggleFunction, initialValue);
}
exports.useToggle = useToggle;
