"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useSessionstorage = void 0;
var react_1 = require("react");
var useDidMount_1 = require("./useDidMount");
var useWarningOnMountInDevelopment_1 = require("./useWarningOnMountInDevelopment");
/**
 * useSessionstorage
 * Tracks a value within sessionStorage and updates it
 *
 * @param key Key of the value to be stored
 * @param defaultValue Default value of the stored item
 * @see {@link https://react-hooks.org/docs/useSessionstorage}
 */
function useSessionstorage(key, defaultValue) {
    if (defaultValue === void 0) { defaultValue = null; }
    (0, useWarningOnMountInDevelopment_1.useWarningOnMountInDevelopment)("useSessionstorage is deprecated, it will be removed in the next major release. Please use useSessionstorageState instead.");
    var parseJSONString = (0, react_1.useCallback)(function (valueToParse) {
        if (!valueToParse) {
            return null;
        }
        try {
            return JSON.parse(valueToParse);
        }
        catch (_a) {
            return valueToParse;
        }
    }, []);
    var getValueFromSessionStorage = (0, react_1.useCallback)(function () {
        var _a;
        if (typeof sessionStorage === "undefined") {
            return null;
        }
        var storedValue = (_a = sessionStorage.getItem(key)) !== null && _a !== void 0 ? _a : "null";
        return parseJSONString(storedValue);
    }, [key, parseJSONString]);
    var _a = (0, react_1.useState)(getValueFromSessionStorage()), value = _a[0], setValue = _a[1];
    var saveValueToSessionStorage = (0, react_1.useCallback)(function (valueToSet) {
        if (typeof sessionStorage === "undefined") {
            return null;
        }
        return sessionStorage.setItem(key, JSON.stringify(valueToSet));
    }, [key]);
    var set = (0, react_1.useCallback)(function (newValue) {
        saveValueToSessionStorage(newValue);
        setValue(newValue);
    }, [saveValueToSessionStorage, setValue]);
    // eslint-disable-next-line consistent-return
    function remove() {
        if (typeof sessionStorage === "undefined") {
            return null;
        }
        sessionStorage.removeItem(key);
        setValue(null);
        return undefined;
    }
    function init() {
        var initialValue = getValueFromSessionStorage();
        if (initialValue === null ||
            initialValue === "null") {
            set(defaultValue);
        }
    }
    (0, useDidMount_1.useDidMount)(function () {
        init();
    });
    var listen = (0, react_1.useCallback)(function (event) {
        if (event.storageArea === sessionStorage && event.key === key) {
            set(parseJSONString(event.newValue));
        }
    }, [key, parseJSONString, set]);
    (0, react_1.useEffect)(function () {
        window.addEventListener("storage", listen);
        return function () {
            window.removeEventListener("storage", listen);
        };
    }, [listen]);
    var handler = Object.assign([value, set, remove], {
        remove: remove,
        set: set,
        value: value,
    });
    return handler;
}
exports.useSessionstorage = useSessionstorage;
