declare type StorageHandlerAsObject<T> = {
    remove: () => null | undefined;
    set: (newValue: T) => void;
    value: T;
};
declare type StorageHandlerAsArray<T> = [T, (newValue: T) => void, () => void];
declare type StorageHandler<T> = StorageHandlerAsArray<T> & StorageHandlerAsObject<T>;
/**
 * useSessionstorage
 * Tracks a value within sessionStorage and updates it
 *
 * @param key Key of the value to be stored
 * @param defaultValue Default value of the stored item
 * @see {@link https://react-hooks.org/docs/useSessionstorage}
 */
declare function useSessionstorage<T>(key: string, defaultValue?: T | null): StorageHandler<T>;
export { useSessionstorage };
