import type { OptionalIndexValue, OptionalIndicesValues } from "../types/index-value";
declare type UseMultiSelectableListReturnType<T> = [
    Array<number[] | T[]>,
    {
        matchSelection: (parameters: OptionalIndexValue<T>) => boolean;
        toggleSelection: (parameters: OptionalIndexValue<T>) => () => void;
        updateSelections: ({ indices, values, }: OptionalIndicesValues<T>) => () => void;
    }
];
/**
 * useMultiSelectableList
 * A custom hook to easily select multiple values from a list
 *
 * @param list - The list of values to select from
 * @param initialSelectIndices - The indices of the initial selections
 * @param allowUnselected - Whether or not to allow unselected values
 * @see {@link https://react-hooks.org/docs/useMultiSelectableList}
 */
declare function useMultiSelectableList<T>(list?: T[], initialSelectIndices?: number[], allowUnselected?: boolean): UseMultiSelectableListReturnType<T>;
export { useMultiSelectableList };
