"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useMapState = void 0;
var react_1 = require("react");
/**
 * useMapState hook
 * A hook to manage state in the form of a map or object.
 *
 * @param initialValue Initial value of the map
 */
function useMapState(initialValue) {
    var _a = (0, react_1.useState)(initialValue), map = _a[0], setMap = _a[1];
    var set = (0, react_1.useCallback)(function (key, value) {
        setMap(function (currentMap) {
            var _a;
            return (__assign(__assign({}, currentMap), (_a = {}, _a[key] = value, _a)));
        });
    }, []);
    var has = (0, react_1.useCallback)(function (key) {
        return typeof map[key] !== "undefined";
    }, [map]);
    var setMultiple = (0, react_1.useCallback)(function (nextMap) {
        setMap(function (currentMap) { return (__assign(__assign({}, currentMap), nextMap)); });
    }, []);
    var removeMultiple = (0, react_1.useCallback)(function () {
        var keys = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            keys[_i] = arguments[_i];
        }
        setMap(function (currentMap) {
            var nextMap = __assign({}, currentMap);
            for (var _i = 0, keys_1 = keys; _i < keys_1.length; _i++) {
                var key = keys_1[_i];
                delete nextMap[key];
            }
            return nextMap;
        });
    }, [setMap]);
    var remove = (0, react_1.useCallback)(function (key) {
        setMap(function (currentMap) {
            var nextMap = __assign({}, currentMap);
            delete nextMap[key];
            return nextMap;
        });
    }, [setMap]);
    var removeAll = (0, react_1.useCallback)(function () {
        setMap(function (currentMap) {
            var nextMap = __assign({}, currentMap);
            for (var key in nextMap) {
                delete nextMap[key];
            }
            return nextMap;
        });
    }, [setMap]);
    return [
        map,
        {
            has: has,
            remove: remove,
            removeAll: removeAll,
            removeMultiple: removeMultiple,
            set: set,
            setMultiple: setMultiple,
        },
    ];
}
exports.useMapState = useMapState;
