/**
 * useMapState hook
 * A hook to manage state in the form of a map or object.
 *
 * @param initialValue Initial value of the map
 */
declare function useMapState<T, K extends keyof T>(initialValue: T): [
    T,
    {
        has: (key: K) => boolean;
        remove: (key: K) => void;
        removeAll: () => void;
        removeMultiple: (...keys: K[]) => void;
        set: (key: K, value: any) => void;
        setMultiple: (next: Partial<T>) => void;
    }
];
export { useMapState };
