"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useKeyBindings = void 0;
var useKey_1 = require("./useKey");
/**
 * useKeyBindings
 *
 * useKeyBindings binds pairs of keyboard events and handlers
 *
 * @param { KeyBindings } keyBindings
 * @param {Options} options
 * @see {@link https://react-hooks.org/docs/useKeyBindings}
 */
var useKeyBindings = function (keyBindings, options) {
    for (var key in keyBindings) {
        // eslint-disable-next-line react-hooks/rules-of-hooks
        (0, useKey_1.useKey)(key, keyBindings[key], options);
    }
};
exports.useKeyBindings = useKeyBindings;
