declare type IntervalHandlerAsObject = {
    /**
     * IntervalId of the interval
     */
    intervalId: ReturnType<typeof setTimeout> | null;
    /**
     * Function to start the interval
     */
    start: () => void;
    /**
     * Function to stop the interval
     */
    stop: () => void;
};
declare type IntervalHandlerAsArray = Array<ReturnType<typeof setTimeout> | (() => void) | null> & {
    0: () => void;
    1: () => void;
    2: ReturnType<typeof setTimeout> | null;
};
declare type IntervalHandler = IntervalHandlerAsArray & IntervalHandlerAsObject;
/**
 *
 * useInterval hook
 *
 * Declaratively creates a setInterval to run a callback after a fixed
 * amount of time
 *
 *@param {Function} callback - Callback to be fired
 *@param {number} intervalId - Interval duration in milliseconds after which the callback is to be fired
 *@param {boolean} startImmediate - Whether the interval should start immediately on initialise
 *@returns {IntervalHandler}
 */
declare function useInterval(callback: () => void, intervalDuration: number | null, startImmediate?: boolean): IntervalHandler;
export { useInterval };
