import type { ChangeEvent } from "react";
declare type InputChangeEvent = ChangeEvent<HTMLInputElement>;
declare type InputHandler<T> = {
    /**
     * Function to handle onChange of an input element
     *
     * @param event The input change event
     */
    onChange: (event: InputChangeEvent) => void;
    /**
     * The current value of the input
     */
    value: T;
};
declare type Options<T> = {
    /**
     * validate
     *
     * Validator function which can be used to prevent updates
     *
     * @param {any} New value
     * @param {any} Current value
     * @returns {boolean} Whether an update should happen or not
     */
    validate?: (newValue: T, currentValue: T) => boolean;
};
/**
 *
 * useInput Hook
 *
 * Handles an input's value and onChange props internally to
 * make text input creation process easier
 *
 * @param {unknown} [initialValue] Initial value of the input
 * @param {Options} [options] Options object
 * @returns {InputHandler} Input handler with value and onChange
 */
declare function useInput<T extends number | string | readonly string[] | undefined = string>(initialValue?: T, options?: Options<T>): InputHandler<T>;
export { useInput };
