"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useGetIsMounted = void 0;
var react_1 = require("react");
/**
 * @description useGetIsMounted hook checks if a component is mounted or not at the time.
 * Useful for async effects. Returns a callback that returns a boolean representing if the component
 * is mounted at the time.
 * @returns () => boolean
 * @see https://react-hooks.org/docs/useGetIsMounted
 */
var useGetIsMounted = function () {
    var isMountedRef = (0, react_1.useRef)(false);
    var get = (0, react_1.useCallback)(function () { return isMountedRef.current; }, []);
    (0, react_1.useEffect)(function () {
        isMountedRef.current = true;
        return function () {
            isMountedRef.current = false;
        };
    }, []);
    return get;
};
exports.useGetIsMounted = useGetIsMounted;
