declare type EventCallback = (this: Document, event_: any) => any;
declare type OnChangeEventCallback = (this: Document, event_: any, isOpen: boolean) => any;
declare type NoopFunction = () => void;
declare type FullscreenApi = {
    element: HTMLElement | null | undefined;
    exit: NoopFunction | (() => Promise<unknown>);
    isEnabled: boolean;
    isFullscreen: boolean;
    /**
     * @deprecated Please use useFullScreen({onChange : function() {}}) instead.
     */
    onChange: NoopFunction | ((callback: OnChangeEventCallback) => void);
    /**
     * @deprecated Please use useFullScreen({onError : function() {}}) instead.
     */
    onError: NoopFunction | ((callback: EventCallback) => void);
    request: NoopFunction | ((element?: HTMLElement) => Promise<unknown>);
    toggle: NoopFunction | ((element?: HTMLElement) => Promise<unknown>);
};
declare type RequestFullscreenOptions = {
    navigationUI?: string | "auto" | "hide" | "show";
};
declare type FullScreenOptions = {
    onChange?: OnChangeEventCallback;
    onError?: EventCallback;
    requestFullscreenOptions?: RequestFullscreenOptions;
};
/**
 * useFullscreen
 * A hook that helps make the document fullscreen
 */
declare function useFullscreen(options?: FullScreenOptions): FullscreenApi;
export { useFullscreen };
