import {useContextProps as $64fa3d84918910a7$export$29f1550f4b0d4415, useRenderProps as $64fa3d84918910a7$export$4d86445c2cf5e3} from "./utils.module.js";
import {useToggleButton as $jrJ9L$useToggleButton, useFocusRing as $jrJ9L$useFocusRing, useHover as $jrJ9L$useHover, mergeProps as $jrJ9L$mergeProps} from "react-aria";
import $jrJ9L$react, {createContext as $jrJ9L$createContext, forwardRef as $jrJ9L$forwardRef} from "react";
import {useToggleState as $jrJ9L$useToggleState} from "react-stately";

/*
 * Copyright 2022 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 



const $efde0372d7a700fe$export$43506d75ebd2e218 = /*#__PURE__*/ (0, $jrJ9L$createContext)({});
function $efde0372d7a700fe$var$ToggleButton(props, ref) {
    [props, ref] = (0, $64fa3d84918910a7$export$29f1550f4b0d4415)(props, ref, $efde0372d7a700fe$export$43506d75ebd2e218);
    let state = (0, $jrJ9L$useToggleState)(props);
    let { buttonProps: buttonProps, isPressed: isPressed } = (0, $jrJ9L$useToggleButton)(props, state, ref);
    let { focusProps: focusProps, isFocused: isFocused, isFocusVisible: isFocusVisible } = (0, $jrJ9L$useFocusRing)(props);
    let { hoverProps: hoverProps, isHovered: isHovered } = (0, $jrJ9L$useHover)(props);
    let renderProps = (0, $64fa3d84918910a7$export$4d86445c2cf5e3)({
        ...props,
        values: {
            isHovered: isHovered,
            isPressed: isPressed,
            isFocused: isFocused,
            isSelected: state.isSelected,
            isFocusVisible: isFocusVisible,
            isDisabled: props.isDisabled || false,
            state: state
        },
        defaultClassName: 'react-aria-ToggleButton'
    });
    return /*#__PURE__*/ (0, $jrJ9L$react).createElement("button", {
        ...(0, $jrJ9L$mergeProps)(buttonProps, focusProps, hoverProps),
        ...renderProps,
        ref: ref,
        slot: props.slot || undefined,
        "data-focused": isFocused || undefined,
        "data-disabled": props.isDisabled || undefined,
        "data-pressed": isPressed || undefined,
        "data-selected": state.isSelected || undefined,
        "data-hovered": isHovered || undefined,
        "data-focus-visible": isFocusVisible || undefined
    });
}
/**
 * A toggle button allows a user to toggle a selection on or off, for example switching between two states or modes.
 */ const $efde0372d7a700fe$export$d2b052e7b4be1756 = /*#__PURE__*/ (0, $jrJ9L$forwardRef)($efde0372d7a700fe$var$ToggleButton);


export {$efde0372d7a700fe$export$43506d75ebd2e218 as ToggleButtonContext, $efde0372d7a700fe$export$d2b052e7b4be1756 as ToggleButton};
//# sourceMappingURL=ToggleButton.module.js.map
