import $f3JOg$react, {createContext as $f3JOg$createContext, useContext as $f3JOg$useContext, forwardRef as $f3JOg$forwardRef, useCallback as $f3JOg$useCallback, useMemo as $f3JOg$useMemo} from "react";

/*
 * Copyright 2024 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 
const $612b8eb6cb90e02d$export$d188a835a7bc5783 = /*#__PURE__*/ (0, $f3JOg$createContext)({});
const $612b8eb6cb90e02d$export$f55761759794cf55 = /*#__PURE__*/ (0, $f3JOg$createContext)(null);
function $612b8eb6cb90e02d$var$DropIndicator(props, ref) {
    let { render: render } = (0, $f3JOg$useContext)($612b8eb6cb90e02d$export$f55761759794cf55);
    return /*#__PURE__*/ (0, $f3JOg$react).createElement((0, $f3JOg$react).Fragment, null, render(props, ref));
}
/**
 * A DropIndicator is rendered between items in a collection to indicate where dropped data will be inserted.
 */ const $612b8eb6cb90e02d$export$62ed72bc21f6b8a6 = /*#__PURE__*/ (0, $f3JOg$forwardRef)($612b8eb6cb90e02d$var$DropIndicator);
function $612b8eb6cb90e02d$export$971707d8a129a1f7(dragAndDropHooks, dropState) {
    var _dragAndDropHooks_isVirtualDragging;
    let renderDropIndicator = dragAndDropHooks === null || dragAndDropHooks === void 0 ? void 0 : dragAndDropHooks.renderDropIndicator;
    let isVirtualDragging = dragAndDropHooks === null || dragAndDropHooks === void 0 ? void 0 : (_dragAndDropHooks_isVirtualDragging = dragAndDropHooks.isVirtualDragging) === null || _dragAndDropHooks_isVirtualDragging === void 0 ? void 0 : _dragAndDropHooks_isVirtualDragging.call(dragAndDropHooks);
    let fn = (0, $f3JOg$useCallback)((target)=>{
        // Only show drop indicators when virtual dragging or this is the current drop target.
        if (isVirtualDragging || (dropState === null || dropState === void 0 ? void 0 : dropState.isDropTarget(target))) return renderDropIndicator ? renderDropIndicator(target) : /*#__PURE__*/ (0, $f3JOg$react).createElement($612b8eb6cb90e02d$export$62ed72bc21f6b8a6, {
            target: target
        });
    // We invalidate whenever the target changes.
    // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [
        dropState === null || dropState === void 0 ? void 0 : dropState.target,
        isVirtualDragging,
        renderDropIndicator
    ]);
    return (dragAndDropHooks === null || dragAndDropHooks === void 0 ? void 0 : dragAndDropHooks.useDropIndicator) ? fn : undefined;
}
function $612b8eb6cb90e02d$export$d1e8e3fbb7461f6(selectionManager, dragAndDropHooks, dropState) {
    var _dragAndDropHooks_isVirtualDragging, _dropState_target;
    // Persist the focused key and the drop target key.
    let focusedKey = selectionManager.focusedKey;
    let dropTargetKey = null;
    if ((dragAndDropHooks === null || dragAndDropHooks === void 0 ? void 0 : (_dragAndDropHooks_isVirtualDragging = dragAndDropHooks.isVirtualDragging) === null || _dragAndDropHooks_isVirtualDragging === void 0 ? void 0 : _dragAndDropHooks_isVirtualDragging.call(dragAndDropHooks)) && (dropState === null || dropState === void 0 ? void 0 : (_dropState_target = dropState.target) === null || _dropState_target === void 0 ? void 0 : _dropState_target.type) === 'item') {
        dropTargetKey = dropState.target.key;
        var _dropState_collection_getKeyAfter;
        if (dropState.target.dropPosition === 'after') // Normalize to the "before" drop position since we only render those to the DOM.
        dropTargetKey = (_dropState_collection_getKeyAfter = dropState.collection.getKeyAfter(dropTargetKey)) !== null && _dropState_collection_getKeyAfter !== void 0 ? _dropState_collection_getKeyAfter : dropTargetKey;
    }
    return (0, $f3JOg$useMemo)(()=>{
        return new Set([
            focusedKey,
            dropTargetKey
        ].filter((k)=>k !== null));
    }, [
        focusedKey,
        dropTargetKey
    ]);
}


export {$612b8eb6cb90e02d$export$d188a835a7bc5783 as DragAndDropContext, $612b8eb6cb90e02d$export$f55761759794cf55 as DropIndicatorContext, $612b8eb6cb90e02d$export$62ed72bc21f6b8a6 as DropIndicator, $612b8eb6cb90e02d$export$971707d8a129a1f7 as useRenderDropIndicator, $612b8eb6cb90e02d$export$d1e8e3fbb7461f6 as useDndPersistedKeys};
//# sourceMappingURL=DragAndDrop.module.js.map
