import {DEFAULT_SLOT as $64fa3d84918910a7$export$c62b8e45d58ddad9, Provider as $64fa3d84918910a7$export$2881499e37b75b9a, useContextProps as $64fa3d84918910a7$export$29f1550f4b0d4415} from "./utils.mjs";
import {HeadingContext as $4e85f108e88277b8$export$d688439359537581} from "./RSPContexts.mjs";
import {PopoverContext as $07b14b47974efb58$export$9b9a0cd73afb7ca4} from "./Popover.mjs";
import {useOverlayTrigger as $6IYYA$useOverlayTrigger, useId as $6IYYA$useId, useDialog as $6IYYA$useDialog} from "react-aria";
import {filterDOMProps as $6IYYA$filterDOMProps} from "@react-aria/utils";
import {useOverlayTriggerState as $6IYYA$useOverlayTriggerState} from "react-stately";
import {PressResponder as $6IYYA$PressResponder} from "@react-aria/interactions";
import $6IYYA$react, {createContext as $6IYYA$createContext, useRef as $6IYYA$useRef, useContext as $6IYYA$useContext, forwardRef as $6IYYA$forwardRef} from "react";

/*
 * Copyright 2022 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 







const $de32f1b87079253c$export$8b93a07348a7730c = /*#__PURE__*/ (0, $6IYYA$createContext)(null);
const $de32f1b87079253c$export$d2f961adcb0afbe = /*#__PURE__*/ (0, $6IYYA$createContext)(null);
function $de32f1b87079253c$export$2e1e1122cf0cba88(props) {
    let state = (0, $6IYYA$useOverlayTriggerState)(props);
    let buttonRef = (0, $6IYYA$useRef)(null);
    let { triggerProps: triggerProps, overlayProps: overlayProps } = (0, $6IYYA$useOverlayTrigger)({
        type: 'dialog'
    }, state, buttonRef);
    // Label dialog by the trigger as a fallback if there is no title slot.
    // This is done in RAC instead of hooks because otherwise we cannot distinguish
    // between context and props. Normally aria-labelledby overrides the title
    // but when sent by context we want the title to win.
    triggerProps.id = (0, $6IYYA$useId)();
    overlayProps['aria-labelledby'] = triggerProps.id;
    return /*#__PURE__*/ (0, $6IYYA$react).createElement((0, $64fa3d84918910a7$export$2881499e37b75b9a), {
        values: [
            [
                $de32f1b87079253c$export$d2f961adcb0afbe,
                state
            ],
            [
                $de32f1b87079253c$export$8b93a07348a7730c,
                overlayProps
            ],
            [
                (0, $07b14b47974efb58$export$9b9a0cd73afb7ca4),
                {
                    trigger: 'DialogTrigger',
                    triggerRef: buttonRef
                }
            ]
        ]
    }, /*#__PURE__*/ (0, $6IYYA$react).createElement((0, $6IYYA$PressResponder), {
        ...triggerProps,
        ref: buttonRef,
        isPressed: state.isOpen
    }, props.children));
}
function $de32f1b87079253c$var$Dialog(props, ref) {
    let originalAriaLabelledby = props['aria-labelledby'];
    [props, ref] = (0, $64fa3d84918910a7$export$29f1550f4b0d4415)(props, ref, $de32f1b87079253c$export$8b93a07348a7730c);
    let { dialogProps: dialogProps, titleProps: titleProps } = (0, $6IYYA$useDialog)({
        ...props,
        // Only pass aria-labelledby from props, not context.
        // Context is used as a fallback below.
        'aria-labelledby': originalAriaLabelledby
    }, ref);
    let state = (0, $6IYYA$useContext)($de32f1b87079253c$export$d2f961adcb0afbe);
    let children = props.children;
    if (typeof children === 'function') children = children({
        close: (state === null || state === void 0 ? void 0 : state.close) || (()=>{})
    });
    if (!dialogProps['aria-label'] && !dialogProps['aria-labelledby']) {
        // If aria-labelledby exists on props, we know it came from context.
        // Use that as a fallback in case there is no title slot.
        if (props['aria-labelledby']) dialogProps['aria-labelledby'] = props['aria-labelledby'];
        else console.warn('If a Dialog does not contain a <Heading slot="title">, it must have an aria-label or aria-labelledby attribute for accessibility.');
    }
    var _props_className;
    return /*#__PURE__*/ (0, $6IYYA$react).createElement("section", {
        ...(0, $6IYYA$filterDOMProps)(props),
        ...dialogProps,
        ref: ref,
        slot: props.slot || undefined,
        style: props.style,
        className: (_props_className = props.className) !== null && _props_className !== void 0 ? _props_className : 'react-aria-Dialog'
    }, /*#__PURE__*/ (0, $6IYYA$react).createElement((0, $64fa3d84918910a7$export$2881499e37b75b9a), {
        values: [
            [
                (0, $4e85f108e88277b8$export$d688439359537581),
                {
                    slots: {
                        [(0, $64fa3d84918910a7$export$c62b8e45d58ddad9)]: {},
                        title: {
                            ...titleProps,
                            level: 2
                        }
                    }
                }
            ]
        ]
    }, children));
}
/**
 * A dialog is an overlay shown above other content in an application.
 */ const $de32f1b87079253c$export$3ddf2d174ce01153 = /*#__PURE__*/ (0, $6IYYA$forwardRef)($de32f1b87079253c$var$Dialog);


export {$de32f1b87079253c$export$8b93a07348a7730c as DialogContext, $de32f1b87079253c$export$d2f961adcb0afbe as OverlayTriggerStateContext, $de32f1b87079253c$export$2e1e1122cf0cba88 as DialogTrigger, $de32f1b87079253c$export$3ddf2d174ce01153 as Dialog};
//# sourceMappingURL=Dialog.module.js.map
