"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var debug_1 = __importDefault(require("debug"));
var events_1 = __importDefault(require("events"));
var pg_format_1 = __importDefault(require("pg-format"));
// Need to require `pg` like this to avoid ugly error message (see #15)
var pg = require("pg");
var connectionLogger = debug_1.default("pg-listen:connection");
var notificationLogger = debug_1.default("pg-listen:notification");
var paranoidLogger = debug_1.default("pg-listen:paranoid");
var subscriptionLogger = debug_1.default("pg-listen:subscription");
var delay = function (ms) { return new Promise(function (resolve) { return setTimeout(resolve, ms); }); };
function connect(connectionConfig, emitter, options) {
    var _this = this;
    connectionLogger("Creating PostgreSQL client for notification streaming");
    var _a = options.retryInterval, retryInterval = _a === void 0 ? 500 : _a, _b = options.retryLimit, retryLimit = _b === void 0 ? Infinity : _b, _c = options.retryTimeout, retryTimeout = _c === void 0 ? 3000 : _c;
    var effectiveConnectionConfig = __assign({}, connectionConfig, { keepAlive: true });
    var Client = options.native && pg.native ? pg.native.Client : pg.Client;
    var dbClient = new Client(effectiveConnectionConfig);
    var getRetryInterval = typeof retryInterval === "function" ? retryInterval : function () { return retryInterval; };
    var reconnect = function (onAttempt) { return __awaiter(_this, void 0, void 0, function () {
        var startTime, _loop_1, attempt, state_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    connectionLogger("Reconnecting to PostgreSQL for notification streaming");
                    startTime = Date.now();
                    _loop_1 = function (attempt) {
                        var newClient_1, connecting, error_1;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0:
                                    connectionLogger("PostgreSQL reconnection attempt #" + attempt + "...");
                                    onAttempt(attempt);
                                    _a.label = 1;
                                case 1:
                                    _a.trys.push([1, 3, , 5]);
                                    newClient_1 = new Client(effectiveConnectionConfig);
                                    connecting = new Promise(function (resolve, reject) {
                                        newClient_1.once("connect", resolve);
                                        newClient_1.once("end", function () { return reject(Error("Connection ended.")); });
                                        newClient_1.once("error", reject);
                                    });
                                    return [4 /*yield*/, Promise.all([
                                            newClient_1.connect(),
                                            connecting
                                        ])];
                                case 2:
                                    _a.sent();
                                    connectionLogger("PostgreSQL reconnection succeeded");
                                    return [2 /*return*/, { value: newClient_1 }];
                                case 3:
                                    error_1 = _a.sent();
                                    connectionLogger("PostgreSQL reconnection attempt failed:", error_1);
                                    return [4 /*yield*/, delay(getRetryInterval(attempt - 1))];
                                case 4:
                                    _a.sent();
                                    if (retryTimeout && (Date.now() - startTime) > retryTimeout) {
                                        throw new Error("Stopping PostgreSQL reconnection attempts after " + retryTimeout + "ms timeout has been reached.");
                                    }
                                    return [3 /*break*/, 5];
                                case 5: return [2 /*return*/];
                            }
                        });
                    };
                    attempt = 1;
                    _a.label = 1;
                case 1:
                    if (!(attempt < retryLimit || !retryLimit)) return [3 /*break*/, 4];
                    return [5 /*yield**/, _loop_1(attempt)];
                case 2:
                    state_1 = _a.sent();
                    if (typeof state_1 === "object")
                        return [2 /*return*/, state_1.value];
                    _a.label = 3;
                case 3:
                    attempt++;
                    return [3 /*break*/, 1];
                case 4: throw new Error("Reconnecting notification client to PostgreSQL database failed.");
            }
        });
    }); };
    return {
        dbClient: dbClient,
        reconnect: reconnect
    };
}
function forwardDBNotificationEvents(dbClient, emitter, parse) {
    var onNotification = function (notification) {
        notificationLogger("Received PostgreSQL notification on \"" + notification.channel + "\":", notification.payload);
        var payload;
        try {
            payload = notification.payload ? parse(notification.payload) : undefined;
        }
        catch (error) {
            error.message = "Error parsing PostgreSQL notification payload: " + error.message;
            return emitter.emit("error", error);
        }
        emitter.emit("notification", {
            processId: notification.processId,
            channel: notification.channel,
            payload: payload
        });
    };
    dbClient.on("notification", onNotification);
    return function cancelNotificationForwarding() {
        dbClient.removeListener("notification", onNotification);
    };
}
function scheduleParanoidChecking(dbClient, intervalTime, reconnect) {
    var _this = this;
    var scheduledCheck = function () { return __awaiter(_this, void 0, void 0, function () {
        var error_2;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    _a.trys.push([0, 2, , 4]);
                    return [4 /*yield*/, dbClient.query("SELECT pg_backend_pid()")];
                case 1:
                    _a.sent();
                    paranoidLogger("Paranoid connection check ok");
                    return [3 /*break*/, 4];
                case 2:
                    error_2 = _a.sent();
                    paranoidLogger("Paranoid connection check failed");
                    connectionLogger("Paranoid connection check failed:", error_2);
                    return [4 /*yield*/, reconnect()];
                case 3:
                    _a.sent();
                    return [3 /*break*/, 4];
                case 4: return [2 /*return*/];
            }
        });
    }); };
    var interval = setInterval(scheduledCheck, intervalTime);
    return function unschedule() {
        clearInterval(interval);
    };
}
function createPostgresSubscriber(connectionConfig, options) {
    var _this = this;
    if (options === void 0) { options = {}; }
    var _a = options.paranoidChecking, paranoidChecking = _a === void 0 ? 30000 : _a, _b = options.parse, parse = _b === void 0 ? JSON.parse : _b, _c = options.serialize, serialize = _c === void 0 ? JSON.stringify : _c;
    var emitter = new events_1.default();
    emitter.setMaxListeners(0); // unlimited listeners
    var notificationsEmitter = new events_1.default();
    notificationsEmitter.setMaxListeners(0); // unlimited listeners
    emitter.on("notification", function (notification) {
        notificationsEmitter.emit(notification.channel, notification.payload);
    });
    var _d = connect(connectionConfig, emitter, options), initialDBClient = _d.dbClient, reconnect = _d.reconnect;
    var closing = false;
    var dbClient = initialDBClient;
    var reinitializingRightNow = false;
    var subscribedChannels = new Set();
    var cancelEventForwarding = function () { return undefined; };
    var cancelParanoidChecking = function () { return undefined; };
    var initialize = function (client) {
        // Wire the DB client events to our exposed emitter's events
        cancelEventForwarding = forwardDBNotificationEvents(client, emitter, parse);
        dbClient.on("error", function (error) {
            if (!reinitializingRightNow) {
                connectionLogger("DB Client error:", error);
                reinitialize();
            }
        });
        dbClient.on("end", function () {
            if (!reinitializingRightNow) {
                connectionLogger("DB Client connection ended");
                reinitialize();
            }
        });
        if (paranoidChecking) {
            cancelParanoidChecking = scheduleParanoidChecking(client, paranoidChecking, reinitialize);
        }
    };
    // No need to handle errors when calling `reinitialize()`, it handles its errors itself
    var reinitialize = function () { return __awaiter(_this, void 0, void 0, function () {
        var subscribedChannelsArray, error_3;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (reinitializingRightNow || closing) {
                        return [2 /*return*/];
                    }
                    reinitializingRightNow = true;
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 4, 5, 6]);
                    cancelParanoidChecking();
                    cancelEventForwarding();
                    dbClient.removeAllListeners();
                    dbClient.once("error", function (error) { return connectionLogger("Previous DB client errored after reconnecting already:", error); });
                    dbClient.end();
                    return [4 /*yield*/, reconnect(function (attempt) { return emitter.emit("reconnect", attempt); })];
                case 2:
                    dbClient = _a.sent();
                    initialize(dbClient);
                    subscribedChannelsArray = Array.from(subscribedChannels);
                    if (subscriptionLogger.enabled) {
                        subscriptionLogger("Re-subscribing to channels: " + subscribedChannelsArray.join(", "));
                    }
                    return [4 /*yield*/, Promise.all(subscribedChannelsArray.map(function (channelName) { return dbClient.query("LISTEN " + pg_format_1.default.ident(channelName)); }))];
                case 3:
                    _a.sent();
                    emitter.emit("connected");
                    return [3 /*break*/, 6];
                case 4:
                    error_3 = _a.sent();
                    error_3.message = "Re-initializing the PostgreSQL notification client after connection loss failed: " + error_3.message;
                    connectionLogger(error_3.stack || error_3);
                    emitter.emit("error", error_3);
                    return [3 /*break*/, 6];
                case 5:
                    reinitializingRightNow = false;
                    return [7 /*endfinally*/];
                case 6: return [2 /*return*/];
            }
        });
    }); };
    // TODO: Maybe queue outgoing notifications while reconnecting
    return {
        /** Emits events: "error", "notification" & "redirect" */
        events: emitter,
        /** For convenience: Subscribe to distinct notifications here, event name = channel name */
        notifications: notificationsEmitter,
        /** Don't forget to call this asyncronous method before doing your thing */
        connect: function () {
            return __awaiter(this, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            initialize(dbClient);
                            return [4 /*yield*/, dbClient.connect()];
                        case 1:
                            _a.sent();
                            emitter.emit("connected");
                            return [2 /*return*/];
                    }
                });
            });
        },
        close: function () {
            connectionLogger("Closing PostgreSQL notification listener.");
            closing = true;
            cancelParanoidChecking();
            return dbClient.end();
        },
        getSubscribedChannels: function () {
            return Array.from(subscribedChannels);
        },
        listenTo: function (channelName) {
            if (subscribedChannels.has(channelName)) {
                return;
            }
            subscriptionLogger("Subscribing to PostgreSQL notification \"" + channelName + "\"");
            subscribedChannels.add(channelName);
            return dbClient.query("LISTEN " + pg_format_1.default.ident(channelName));
        },
        notify: function (channelName, payload) {
            notificationLogger("Sending PostgreSQL notification to \"" + channelName + "\":", payload);
            if (payload !== undefined) {
                var serialized = serialize(payload);
                return dbClient.query("NOTIFY " + pg_format_1.default.ident(channelName) + ", " + pg_format_1.default.literal(serialized));
            }
            else {
                return dbClient.query("NOTIFY " + pg_format_1.default.ident(channelName));
            }
        },
        unlisten: function (channelName) {
            if (!subscribedChannels.has(channelName)) {
                return;
            }
            subscriptionLogger("Unsubscribing from PostgreSQL notification \"" + channelName + "\"");
            subscribedChannels.delete(channelName);
            return dbClient.query("UNLISTEN " + pg_format_1.default.ident(channelName));
        },
        unlistenAll: function () {
            subscriptionLogger("Unsubscribing from all PostgreSQL notifications.");
            subscribedChannels = new Set();
            return dbClient.query("UNLISTEN *");
        }
    };
}
exports.default = createPostgresSubscriber;
