# is-self-closing [![NPM version](https://img.shields.io/npm/v/is-self-closing.svg?style=flat)](https://www.npmjs.com/package/is-self-closing) [![NPM monthly downloads](https://img.shields.io/npm/dm/is-self-closing.svg?style=flat)](https://npmjs.org/package/is-self-closing) [![NPM total downloads](https://img.shields.io/npm/dt/is-self-closing.svg?style=flat)](https://npmjs.org/package/is-self-closing) [![Linux Build Status](https://img.shields.io/travis/jonschlinkert/is-self-closing.svg?style=flat&label=Travis)](https://travis-ci.org/jonschlinkert/is-self-closing)

> Returns true if the given name is a HTML void element or common SVG self-closing element.

Please consider following this project's author, [Jon Schlinkert](https://github.com/jonschlinkert), and consider starring the project to show your :heart: and support.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save is-self-closing
```

## Usage

```js
var isSelfClosing = require('is-self-closing');

console.log(isSelfClosing('path')); // SVG
console.log(isSelfClosing('img'));
//=> true

console.log(isSelfClosing('foo'));
//=> false
```

## About

<details>
<summary><strong>Contributing</strong></summary>

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

Please read the [contributing guide](.github/contributing.md) for advice on opening issues, pull requests, and coding standards.

</details>

<details>
<summary><strong>Running Tests</strong></summary>

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

</details>

<details>
<summary><strong>Building docs</strong></summary>

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

</details>

### Related projects

You might also be interested in these projects:

* [breakdance](https://www.npmjs.com/package/breakdance): Breakdance is a node.js library for converting HTML to markdown. Highly pluggable, flexible and easy… [more](http://breakdance.io) | [homepage](http://breakdance.io "Breakdance is a node.js library for converting HTML to markdown. Highly pluggable, flexible and easy to use. It's time for your markup to get down.")
* [html-tag](https://www.npmjs.com/package/html-tag): Generate HTML elements from a javascript object. | [homepage](https://github.com/jonschlinkert/html-tag "Generate HTML elements from a javascript object.")
* [html-toc](https://www.npmjs.com/package/html-toc): Generate a HTML table of contents using cheerio. | [homepage](https://github.com/jonschlinkert/html-toc "Generate a HTML table of contents using cheerio.")
* [remarkable](https://www.npmjs.com/package/remarkable): Markdown parser, done right. 100% Commonmark support, extensions, syntax plugins, high speed - all in… [more](https://github.com/jonschlinkert/remarkable) | [homepage](https://github.com/jonschlinkert/remarkable "Markdown parser, done right. 100% Commonmark support, extensions, syntax plugins, high speed - all in one.")
* [self-closing-tags](https://www.npmjs.com/package/self-closing-tags): HTML void elements are not the only self-closing tags. This includes common SVG self-closing elements… [more](https://github.com/jonschlinkert/self-closing-tags) | [homepage](https://github.com/jonschlinkert/self-closing-tags "HTML void elements are not the only self-closing tags. This includes common SVG self-closing elements as well.")

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.6.0, on October 30, 2017._