# is-invalid-path [![NPM version](https://img.shields.io/npm/v/is-invalid-path.svg?style=flat)](https://www.npmjs.com/package/is-invalid-path) [![NPM monthly downloads](https://img.shields.io/npm/dm/is-invalid-path.svg?style=flat)](https://npmjs.org/package/is-invalid-path) [![NPM total downloads](https://img.shields.io/npm/dt/is-invalid-path.svg?style=flat)](https://npmjs.org/package/is-invalid-path) [![Linux Build Status](https://img.shields.io/travis/jonschlinkert/is-invalid-path.svg?style=flat&label=Travis)](https://travis-ci.org/jonschlinkert/is-invalid-path)

> Returns true if a windows file path has invalid characters.

Please consider following this project's author, [Jon Schlinkert](https://github.com/jonschlinkert), and consider starring the project to show your :heart: and support.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save is-invalid-path
```

## Usage

```js
const isInvalid = require('is-invalid-path');

// true if the path is not a string or has invalid characters
console.log(isInvalid());       //=> true
console.log(isInvalid('<abc')); //=> true
console.log(isInvalid('>abc')); //=> true
console.log(isInvalid(':abc')); //=> true
console.log(isInvalid('"abc')); //=> true
console.log(isInvalid('|abc')); //=> true
console.log(isInvalid('?abc')); //=> true
console.log(isInvalid('*abc')); //=> true

// true if the path has slashes and options.file is true,
// as slashes and backslashes are invalid in file names
console.log(isInvalid('foo/abc', { file: true })); //=> true
console.log(isInvalid('foo\\abc', { file: true })); //=> true
```

## About

<details>
<summary><strong>Contributing</strong></summary>

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

</details>

<details>
<summary><strong>Running Tests</strong></summary>

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

</details>

<details>
<summary><strong>Building docs</strong></summary>

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

</details>

### Related projects

You might also be interested in these projects:

* [is-glob](https://www.npmjs.com/package/is-glob): Returns `true` if the given string looks like a glob pattern or an extglob pattern… [more](https://github.com/jonschlinkert/is-glob) | [homepage](https://github.com/jonschlinkert/is-glob "Returns `true` if the given string looks like a glob pattern or an extglob pattern. This makes it easy to create code that only uses external modules like node-glob when necessary, resulting in much faster code execution and initialization time, and a bet")
* [is-windows](https://www.npmjs.com/package/is-windows): Returns true if the platform is windows. UMD module, works with node.js, commonjs, browser, AMD… [more](https://github.com/jonschlinkert/is-windows) | [homepage](https://github.com/jonschlinkert/is-windows "Returns true if the platform is windows. UMD module, works with node.js, commonjs, browser, AMD, electron, etc.")

### Author

**Jon Schlinkert**

* [LinkedIn Profile](https://linkedin.com/in/jonschlinkert)
* [GitHub Profile](https://github.com/jonschlinkert)
* [Twitter Profile](https://twitter.com/jonschlinkert)

### License

Copyright © 2018, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.6.0, on April 19, 2018._