import { isSet } from "./isSet";
import { getFullScope } from "./getFullScope";
import { inferType } from "./inferType";
export function lookup(i18n, scope, options = {}) {
    options = Object.assign({}, options);
    const locale = "locale" in options ? options.locale : i18n.locale;
    const localeType = inferType(locale);
    const locales = i18n.locales
        .get(localeType === "string" ? locale : typeof locale)
        .slice();
    const keys = getFullScope(i18n, scope, options)
        .split(i18n.defaultSeparator)
        .map((component) => i18n.transformKey(component));
    const entries = locales.map((locale) => keys.reduce((path, key) => path && path[key], i18n.translations[locale]));
    entries.push(options.defaultValue);
    return entries.find((entry) => isSet(entry));
}
//# sourceMappingURL=lookup.js.map