'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true,
});
exports.StreamDirectiveOnListFieldRule = StreamDirectiveOnListFieldRule;

var _GraphQLError = require('../../error/GraphQLError.js');

var _definition = require('../../type/definition.js');

var _directives = require('../../type/directives.js');

/**
 * Stream directive on list field
 *
 * A GraphQL document is only valid if stream directives are used on list fields.
 */
function StreamDirectiveOnListFieldRule(context) {
  return {
    Directive(node) {
      const fieldDef = context.getFieldDef();
      const parentType = context.getParentType();

      if (
        fieldDef &&
        parentType &&
        node.name.value === _directives.GraphQLStreamDirective.name &&
        !(
          (0, _definition.isListType)(fieldDef.type) ||
          ((0, _definition.isWrappingType)(fieldDef.type) &&
            (0, _definition.isListType)(fieldDef.type.ofType))
        )
      ) {
        context.reportError(
          new _GraphQLError.GraphQLError(
            `Stream directive cannot be used on non-list field "${fieldDef.name}" on type "${parentType.name}".`,
            node,
          ),
        );
      }
    },
  };
}
