# get-object [![NPM version](https://badge.fury.io/js/get-object.svg)](http://badge.fury.io/js/get-object)

> Get a property from an object using dot (object path) notation.

## Install

Install with [npm](https://www.npmjs.com/)

```sh
$ npm i get-object --save
```

## Usage

```js
var get = require('get-object');

get({a: {b: {c: 'd'}}}, 'a.b.c');
//=> {c: 'd'}
```

If you want only the value, not key/value, use [get-value](https://github.com/jonschlinkert/get-value).

## get a value from an object

```js
get({a: 'aaa', b: {c: 'd'}}, 'a');
//=> {a: 'aaa'}

get({a: 'a', b: {c: 'd'}}, 'b.c');
//=> {c: 'd'}
```

## get a value from an array

```js
get(['a', 'b', 'c'], '0');
//=> ['a']

get(['a', 'b', 'c'], 2);
//=> ['c']
```

## get nested value from an array

```js
get({a: ['a', 'b', 'c']}, 'a.0');
//=> ['a']

get({a: ['a', 'b', 'c']}, 'a.2');
//=> ['c']

get({a: {b: ['a', 'b', 'c']}}, 'a.b.2');
//=> ['c']
```

## support array notation

```js
get({a: ['a', 'b', 'c']}, 'a[0]');
//=> ['a']

get({a: ['a', 'b', 'c']}, 'a[2]');
//=> ['c']

get({a: {b: ['a', 'b', {c: 'd'}]}}, 'a.b[2].c');
//=> {c: 'd'}
```

## Related projects

* [del-value](https://www.npmjs.com/package/del-value): Delete deeply nested value from an object using dot notation like `  a.b.c.x` and return the… [more](https://www.npmjs.com/package/del-value) | [homepage](https://github.com/tunnckocore/del-value)
* [get-value](https://www.npmjs.com/package/get-value): Use property paths (`  a.b.c`) to get a nested value from an object. | [homepage](https://github.com/jonschlinkert/get-value)
* [set-value](https://www.npmjs.com/package/set-value): Create nested values and any intermediaries using dot notation (`'a.b.c'`) paths. | [homepage](https://github.com/jonschlinkert/set-value)
* [union-value](https://www.npmjs.com/package/union-value): Set an array of unique values as the property of an object. Supports setting deeply… [more](https://www.npmjs.com/package/union-value) | [homepage](https://github.com/jonschlinkert/union-value)
* [unset-value](https://www.npmjs.com/package/unset-value): Delete nested properties from an object using dot notation. | [homepage](https://github.com/jonschlinkert/unset-value)
* [upsert-value](https://www.npmjs.com/package/upsert-value): Update or set nested values and any intermediaries with dot notation (`'a.b.c'`) paths. | [homepage](https://github.com/doowb/upsert-value)

## Running tests

Install dev dependencies:

```sh
$ npm i -d && npm test
```

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/get-object/issues/new).

## Author

**Jon Schlinkert**

+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2015 Jon Schlinkert
Released under the MIT license.

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on August 27, 2015._
