"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.get = get;
exports.without = without;
exports.isString = isString;
exports.isObject = isObject;
exports.xor = xor;
exports.intersection = intersection;
function get(obj, path, defaultValue) {
    return path.split('.').reduce((a, c)=>a && a[c] ? a[c] : defaultValue || null
    , obj);
}
function without(items, item) {
    return items.filter((i)=>i !== item
    );
}
function isString(input) {
    return typeof input === 'string';
}
function isObject(input) {
    return typeof input === 'object';
}
function xor(itemsA, itemsB) {
    const map = new Map();
    const insertItem = (item)=>{
        map.set(item, map.has(item) ? map.get(item) + 1 : 1);
    };
    itemsA.forEach(insertItem);
    itemsB.forEach(insertItem);
    const result = [];
    map.forEach((count, key)=>{
        if (count === 1) {
            result.push(key);
        }
    });
    return result;
}
function intersection(itemsA, itemsB) {
    return itemsA.filter((t)=>itemsB.indexOf(t) > -1
    );
}

//# sourceMappingURL=js_utils.js.map