"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateWidthValue = exports.calculateFormSpacingValues = void 0;
var _styledSystem = require("styled-system");
var _dialog = require("../../components/dialog/dialog.config");
var _sidebar = require("../../components/sidebar/sidebar.config");
const parsePadding = paddingString => {
  const paddingValues = paddingString.split(/\s+/);
  let paddingTop, paddingBottom, paddingLeft, paddingRight;
  switch (paddingValues.length) {
    case 1:
      {
        const [value] = paddingValues;
        [paddingTop, paddingRight, paddingBottom, paddingLeft] = [value, value, value, value];
        break;
      }
    case 2:
      {
        const [vertical, horizontal] = paddingValues;
        [paddingTop, paddingRight, paddingBottom, paddingLeft] = [vertical, horizontal, vertical, horizontal];
        break;
      }
    case 3:
      {
        const [top, horizontal, bottom] = paddingValues;
        [paddingTop, paddingRight, paddingBottom, paddingLeft] = [top, horizontal, bottom, horizontal];
        break;
      }
    case 4:
      {
        [paddingTop, paddingRight, paddingBottom, paddingLeft] = paddingValues;
        break;
      }
    /* istanbul ignore next */
    default:
      break;
  }
  return {
    paddingTop,
    paddingBottom,
    paddingLeft,
    paddingRight
  };
};
const calculatePadding = props => {
  const {
    padding,
    ...individualPaddingProperties
  } = (0, _styledSystem.padding)(props);
  const result = padding ? parsePadding(padding) : {};
  Object.assign(result, individualPaddingProperties);
  return result;
};
const calculateWidthValue = props => {
  const {
    paddingLeft,
    paddingRight
  } = calculatePadding(props);
  const paddingValue = `(${paddingLeft ?? `${_dialog.HORIZONTAL_PADDING}px`} + ${paddingRight ?? `${_dialog.HORIZONTAL_PADDING}px`})`;
  return `width: calc(100% + ${paddingValue});`;
};
exports.calculateWidthValue = calculateWidthValue;
const calculateFormSpacingValues = (props, isFormContent, containerComponent = "dialog") => {
  const {
    paddingTop,
    paddingBottom,
    paddingLeft,
    paddingRight
  } = calculatePadding(props);
  const isSidebar = containerComponent === "sidebar";
  const spacingTopValue = paddingTop ?? (isSidebar ? _sidebar.SIDEBAR_TOP_SPACING : `${_dialog.CONTENT_TOP_PADDING}px`);
  const spacingRightValue = paddingRight ?? `${_dialog.HORIZONTAL_PADDING}px`;
  const spacingBottomValue = paddingBottom ?? (isSidebar ? _sidebar.SIDEBAR_BOTTOM_SPACING : `${_dialog.CONTENT_BOTTOM_PADDING}px`);
  const spacingLeftValue = paddingLeft ?? `${_dialog.HORIZONTAL_PADDING}px`;
  const setNegativeValue = value => `calc(-1 * ${value})`;
  return {
    "margin-left": setNegativeValue(spacingLeftValue),
    "margin-right": setNegativeValue(spacingRightValue),
    ...(isFormContent ? {
      "margin-top": setNegativeValue(spacingTopValue),
      "padding-top": spacingTopValue,
      "padding-bottom": isSidebar ? undefined : spacingBottomValue,
      "padding-left": spacingLeftValue,
      "padding-right": spacingRightValue
    } : {
      "margin-bottom": setNegativeValue(spacingBottomValue),
      ...(isSidebar && {
        // if footer already has custom padding do not set
        ":not(.padded)": {
          "padding-left": _sidebar.SIDEBAR_LEFT_PADDING,
          "padding-right": _sidebar.SIDEBAR_RIGHT_PADDING
        }
      })
    })
  };
};
exports.calculateFormSpacingValues = calculateFormSpacingValues;