"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toColor = exports.default = void 0;
var _styledSystem = require("styled-system");
var _common = _interopRequireDefault(require("@sage/design-tokens/js/base/common"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
// eslint-disable-next-line no-restricted-imports

/*
 * styled-system/color allows users to use a color from the theme, from the `colors` object.
 *
 * The DLS defines colors in shades or tints rather than explicitly listing all possible colours
 * e.g. goldTint10, brilliantGreenShade55
 *
 * In our palette we have methods to access these colors
 * e.g. palette.goldTint(10)
 *
 * We could use a proxy to make those calls directly on the theme however styled-components expects the theme to be a
 * plain object and does not allow us to merge a theme from a ThemeProvider with a theme defined as a defaultProp if
 * both of those have a Proxy.
 * e.g. when the none theme in the ThemeProvider is merged with the base theme in the defaultProps
 *
 * The purpose of this function is to intercept any palette colors, we only want styled-system to deal with CSS strings
 * and theme.colors.
 *
 * This allows us to keep our themes as plain objects.
 */

const toColor = (theme, color) => {
  if (color.startsWith("--") && color.slice(2) in _common.default) {
    return `var(${color})`;
  }
  const {
    palette
  } = theme;
  const percentage = color.match(/\d+/);
  const method = color.match(/[a-zA-Z]+/)?.toString();
  if (method && method in palette) {
    const match = palette[method];
    if (typeof match === "function") {
      const arg = ["blackOpacity", "whiteOpacity"].includes(method) ? `0.${percentage}` : percentage;
      return match(arg);
    }
    return match;
  }
  return color;
};
exports.toColor = toColor;
var _default = ({
  color,
  bg,
  backgroundColor,
  ...rest
}) => {
  const obj = {};
  obj.color = color ? toColor(rest.theme, color) : undefined;
  obj.bg = bg || backgroundColor ? toColor(rest.theme, bg || backgroundColor) : undefined;
  return (0, _styledSystem.color)({
    ...rest,
    ...obj
  });
};
exports.default = _default;