"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mergeWithBase = exports.default = void 0;
var _baseTheme = _interopRequireDefault(require("./base-theme.config"));
var _colorConfig = _interopRequireDefault(require("../../color-config"));
var _atOpacity = _interopRequireDefault(require("../../utils/at-opacity"));
var _mergeDeep = require("../../utils/merge-deep");
var _palette = _interopRequireDefault(require("../../palette"));
var _addHexSymbols = _interopRequireDefault(require("../../utils/add-hex-symbols"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const colors = (0, _palette.default)(_colorConfig.default);
const colorsWithHex = (0, _addHexSymbols.default)(_colorConfig.default);
const blackOpacity = (0, _atOpacity.default)("#000000");
const whiteOpacity = (0, _atOpacity.default)("#FFFFFF");
const palette = {
  ...colors,
  ...colorsWithHex,
  blackOpacity,
  whiteOpacity
};
const baseTheme = (0, _baseTheme.default)(palette);
var _default = exports.default = baseTheme;
const mergeWithBase = configureTheme => {
  const themeToMergeWithBase = configureTheme(palette);
  return {
    ...(0, _mergeDeep.mergeDeep)(baseTheme, themeToMergeWithBase),
    palette
  };
};
exports.mergeWithBase = mergeWithBase;